/*
 * Copyright (c) 2009,2010 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.app.views.layercomp;

import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.app.PropertyUtil;
import ch.kuramo.javie.app.project.ClearLayerKeyframesOperation;
import ch.kuramo.javie.app.project.ModifyLayerAnimatableValueOperation;
import ch.kuramo.javie.app.project.ModifyLayerExpressionOperation;
import ch.kuramo.javie.app.project.ModifyLayerKeyframeOperation;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.project.ProjectOperation;
import ch.kuramo.javie.core.AnimatableBoolean;
import ch.kuramo.javie.core.AnimatableColor;
import ch.kuramo.javie.core.AnimatableDouble;
import ch.kuramo.javie.core.AnimatableEnum;
import ch.kuramo.javie.core.AnimatableInteger;
import ch.kuramo.javie.core.AnimatableString;
import ch.kuramo.javie.core.AnimatableValue;
import ch.kuramo.javie.core.AnimatableVec2d;
import ch.kuramo.javie.core.AnimatableVec3d;
import ch.kuramo.javie.core.JavieRuntimeException;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerNature;

public class LayerAnimatableValueElement extends AnimatableValueElement {

	protected final Layer layer;

	protected final String property;

	protected final String name;

	protected final String unit;


	public LayerAnimatableValueElement(Element parent, Layer layer, String property, String name, String unit) {
		super(parent);
		this.layer = layer;
		this.property = property;
		this.name = name;
		this.unit = unit;
	}

	public LayerAnimatableValueElement(Element parent, Layer layer, String property, String name) {
		this(parent, layer, property, name, null);
	}

	protected AnimatableValueElementDelegate<?> createDelegate() {
		AnimatableValue<?> avalue = PropertyUtil.getProperty(layer, property);

		if (avalue instanceof AnimatableVec3d) {
			boolean threeD = LayerNature.isThreeD(layer);
			return new AnimatableVec3dElementDelegate(this, name, (AnimatableVec3d) avalue, threeD, unit);

		} else if (avalue instanceof AnimatableVec2d) {
			return new AnimatableVec2dElementDelegate(this, name, (AnimatableVec2d) avalue, unit);

		} else if (avalue instanceof AnimatableDouble) {
			return new AnimatableDoubleElementDelegate(this, name, (AnimatableDouble) avalue, unit);

		} else if (avalue instanceof AnimatableInteger) {
			return new AnimatableIntegerElementDelegate(this, name, (AnimatableInteger) avalue, unit);

		} else if (avalue instanceof AnimatableString) {
			return new AnimatableStringElementDelegate(this, name, (AnimatableString) avalue);

		} else if (avalue instanceof AnimatableBoolean) {
			return new AnimatableBooleanElementDelegate(this, name, (AnimatableBoolean) avalue);

		} else if (avalue instanceof AnimatableColor) {
			return new AnimatableColorElementDelegate(this, name, (AnimatableColor) avalue);

		} else if (avalue instanceof AnimatableEnum<?>) {
			@SuppressWarnings("unchecked")
			AnimatableEnumElementDelegate<?> delegate = new AnimatableEnumElementDelegate(this, name, (AnimatableEnum) avalue);
			return delegate;

		} else {
			throw new JavieRuntimeException("unsupported property type: " + avalue.getClass().getName());
		}
	}

	protected ProjectOperation createModifyValueOperation(ProjectManager pm, Object newValue, String relation) {
		return new ModifyLayerAnimatableValueOperation<Object>(pm, layer, property, newValue, relation, name);
	}

	protected ProjectOperation createModifyExpressionOperation(ProjectManager pm, String newExpr) {
		return new ModifyLayerExpressionOperation(pm, layer, property, newExpr);
	}

	protected ProjectOperation createModifyKeyframeOperation(ProjectManager pm, Time time, Object newValue, String relation) {
		return new ModifyLayerKeyframeOperation<Object>(pm, layer, property, time, newValue, relation, name);
	}

	protected ProjectOperation createClearKeyframesOperation(ProjectManager pm) {
		return new ClearLayerKeyframesOperation<Object>(pm, layer, property);
	}

	protected String getDefaultExpression() {
		return property;
	}

	public Layer getLayer() {
		return layer;
	}

	public String getProperty() {
		return property;
	}

}
