/*
 * Copyright (c) 2009 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.api;

public final class RenderResolution {

	public static final RenderResolution FULL		= new RenderResolution(1);
	public static final RenderResolution HALF		= new RenderResolution(1/2d);
	public static final RenderResolution ONETHIRD	= new RenderResolution(1/3d);
	public static final RenderResolution QUARTER	= new RenderResolution(1/4d);


	public final double scale;


	public RenderResolution(double scale) {
		this.scale = scale;
	}

	public double scale(double d) {
		return d * scale;
	}

	public Size2i scale(Size2i size) {
		return (scale == 1) ? size : new Size2i((int) (size.width * scale), (int) (size.height * scale));
	}

	public VideoBounds scale(VideoBounds bounds) {
		return (scale == 1) ? bounds : new VideoBounds(bounds.x * scale, bounds.y * scale, 
											(int) (bounds.width * scale), (int) (bounds.height * scale));
	}

	public Vec2d scale(Vec2d vec) {
		return (scale == 1) ? vec : new Vec2d(vec.x * scale, vec.y * scale);
	}

	public Vec3d scale(Vec3d vec) {
		return (scale == 1) ? vec : new Vec3d(vec.x * scale, vec.y * scale, vec.z * scale);
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		long temp;
		temp = Double.doubleToLongBits(scale);
		result = prime * result + (int) (temp ^ (temp >>> 32));
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		RenderResolution other = (RenderResolution) obj;
		if (Double.doubleToLongBits(scale) != Double.doubleToLongBits(other.scale))
			return false;
		return true;
	}

	@Override
	public String toString() {
		return "RenderResolution [" + scale + "]";
	}

}
