/*
 * Copyright (c) 2009,2010 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.app;

import java.io.PrintStream;
import java.net.URL;

import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

import ch.kuramo.javie.core.misc.JsonicBugFix;

/**
 * The activator class controls the plug-in life cycle
 */
public class Activator extends AbstractUIPlugin {

	// The plug-in ID
	public static final String PLUGIN_ID = "ch.kuramo.javie.app";

	// The shared instance
	private static Activator plugin;


	private ColorRegistry colorRegistry;

	/**
	 * The constructor
	 */
	public Activator() {
	}

	private void createDefaultConsole() {
		MessageConsole console = new MessageConsole("コンソール", null);
		IConsoleManager consoleManager = ConsolePlugin.getDefault().getConsoleManager();
		consoleManager.addConsoles(new IConsole[] { console });

		IOConsoleOutputStream out = console.newOutputStream();
		IOConsoleOutputStream err = console.newOutputStream();

		System.setOut(new PrintStream(out));
		System.setErr(new PrintStream(err));

		Display display = Display.getDefault();
		//console.setBackground(display.getSystemColor(SWT.COLOR_GRAY));
		err.setColor(display.getSystemColor(SWT.COLOR_RED));
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#start(org.osgi.framework.BundleContext)
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
		plugin = this;

		// スペースが%20で表現されるURLでScannotationを使う場合は次の呼び出しを行ってScannotationのコードを修正する必要があるが、
		// FileLocator.resolveが返すURLはスペースが%20にならずスペースのままなので、オリジナルのScannotationでそのまま動作する。
		//ScannotationBugFix.patch();

		JsonicBugFix.patch();
		DragSourceEnhancement.patch();
		DropTargetEnhancement.patch();
		ColorDialogBugFix.patch();

		createDefaultConsole();
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#stop(org.osgi.framework.BundleContext)
	 */
	public void stop(BundleContext context) throws Exception {
		plugin = null;
		super.stop(context);
	}

	/**
	 * Returns the shared instance
	 *
	 * @return the shared instance
	 */
	public static Activator getDefault() {
		return plugin;
	}

	/**
	 * Returns an image descriptor for the image file at the given
	 * plug-in relative path
	 *
	 * @param path the path
	 * @return the image descriptor
	 */
	public static ImageDescriptor getImageDescriptor(String path) {
		return imageDescriptorFromPlugin(PLUGIN_ID, path);
	}


	public static final String IMG_PLAYER_PLAY			= "IMG_PLAYER_PLAY";
	public static final String IMG_PLAYER_PAUSE			= "IMG_PLAYER_PAUSE";
	public static final String IMG_PLAYER_HEAD			= "IMG_PLAYER_HEAD";
	public static final String IMG_PLAYER_PREV			= "IMG_PLAYER_PREV";
	public static final String IMG_PLAYER_NEXT			= "IMG_PLAYER_NEXT";
	public static final String IMG_PLAYER_LAST			= "IMG_PLAYER_LAST";
	public static final String IMG_PLAYER_ZOOM			= "IMG_PLAYER_ZOOM";
	public static final String IMG_PLAYER_RESOLUTION	= "IMG_PLAYER_RESOLUTION";
	public static final String IMG_PLAYER_MUTE			= "IMG_PLAYER_MUTE";
	public static final String IMG_PLAYER_NOMUTE		= "IMG_PLAYER_NOMUTE";
	public static final String IMG_PLAYER_INFO			= "IMG_PLAYER_INFO";
	public static final String IMG_PLAYER_PIN			= "IMG_PLAYER_PIN";

	public static final String IMG_CAMERA	= "IMG_CAMERA";
	public static final String IMG_TEXT		= "IMG_TEXT";

	public static final String IMG_SWITCH_VIDEO = "IMG_SWITCH_VIDEO";
	public static final String IMG_SWITCH_AUDIO = "IMG_SWITCH_AUDIO";

	public static final String IMG_SWITCH_UNSHY			= "IMG_SWITCH_UNSHY";
	public static final String IMG_SWITCH_SHY			= "IMG_SWITCH_SHY";
	public static final String IMG_SWITCH_EFFECT		= "IMG_SWITCH_EFFECT";
	public static final String IMG_SWITCH_CTCR			= "IMG_SWITCH_CTCR";
	public static final String IMG_SWITCH_3D			= "IMG_SWITCH_3D";
	public static final String IMG_SWITCH_LINK			= "IMG_SWITCH_LINK";
	public static final String IMG_SWITCH_TRANSLATE2D	= "IMG_SWITCH_TRANSLATE2D";

	public static final String IMG_KF_HOLD					= "IMG_KF_HOLD";
	public static final String IMG_KF_HOLD_SELECT			= "IMG_KF_HOLD_SELECT";
	public static final String IMG_KF_LINEAR				= "IMG_KF_LINEAR";
	public static final String IMG_KF_LINEAR_SELECT			= "IMG_KF_LINEAR_SELECT";
	public static final String IMG_KF_CATMULL_ROM			= "IMG_KF_CATMULL_ROM";
	public static final String IMG_KF_CATMULL_ROM_SELECT	= "IMG_KF_CATMULL_ROM_SELECT";
	public static final String IMG_KF_SLERP					= "IMG_KF_SLERP";
	public static final String IMG_KF_SLERP_SELECT			= "IMG_KF_SLERP_SELECT";

	public static final String IMG_STOPWATCH_NO_KF	= "IMG_STOPWATCH_NO_KF";
	public static final String IMG_STOPWATCH_HAS_KF	= "IMG_STOPWATCH_HAS_KF";

	protected void initializeImageRegistry(ImageRegistry reg) {
		registerImage(reg, IMG_PLAYER_PLAY, "player_play.png");
		registerImage(reg, IMG_PLAYER_PAUSE, "player_pause.png");
		registerImage(reg, IMG_PLAYER_HEAD, "player_head.png");
		registerImage(reg, IMG_PLAYER_PREV, "player_prev.png");
		registerImage(reg, IMG_PLAYER_NEXT, "player_next.png");
		registerImage(reg, IMG_PLAYER_LAST, "player_last.png");
		registerImage(reg, IMG_PLAYER_ZOOM, "player_zoom.png");
		registerImage(reg, IMG_PLAYER_RESOLUTION, "player_resolution.png");
		registerImage(reg, IMG_PLAYER_MUTE, "player_mute.png");
		registerImage(reg, IMG_PLAYER_NOMUTE, "player_nomute.png");
		registerImage(reg, IMG_PLAYER_INFO, "player_info.png");
		registerImage(reg, IMG_PLAYER_PIN, "player_pin.png");

		registerImage(reg, IMG_CAMERA, "camera.png");
		registerImage(reg, IMG_TEXT, "text.png");

		registerImage(reg, IMG_SWITCH_VIDEO, "switch_video.png");
		registerImage(reg, IMG_SWITCH_AUDIO, "switch_audio.png");

		registerImage(reg, IMG_SWITCH_UNSHY, "switch_unshy.png");
		registerImage(reg, IMG_SWITCH_SHY, "switch_shy.png");
		registerImage(reg, IMG_SWITCH_CTCR, "switch_ctcr.png");
		registerImage(reg, IMG_SWITCH_EFFECT, "switch_effect.png");
		registerImage(reg, IMG_SWITCH_3D, "switch_3d.png");
		registerImage(reg, IMG_SWITCH_LINK, "switch_link.png");
		registerImage(reg, IMG_SWITCH_TRANSLATE2D, "switch_translate2d.png");

		registerImage(reg, IMG_KF_HOLD,        "kf_hold.png");
		registerImage(reg, IMG_KF_HOLD_SELECT, "kf_hold_select.png");
		registerImage(reg, IMG_KF_LINEAR,        "kf_linear.png");
		registerImage(reg, IMG_KF_LINEAR_SELECT, "kf_linear_select.png");
		registerImage(reg, IMG_KF_CATMULL_ROM,        "kf_catmull_rom.png");
		registerImage(reg, IMG_KF_CATMULL_ROM_SELECT, "kf_catmull_rom_select.png");
		registerImage(reg, IMG_KF_SLERP,        "kf_slerp.png");
		registerImage(reg, IMG_KF_SLERP_SELECT, "kf_slerp_select.png");

		registerImage(reg, IMG_STOPWATCH_NO_KF,  "stopwatch_no_kf.png");
		registerImage(reg, IMG_STOPWATCH_HAS_KF, "stopwatch_has_kf.png");
	}

	private void registerImage(ImageRegistry registry, String key, String filename) {
		IPath path = new Path("icons/" + filename);
		URL url = FileLocator.find(getBundle(), path, null);
		if (url != null) {
			ImageDescriptor desc = ImageDescriptor.createFromURL(url);
			registry.put(key, desc);
		}
	}


	public static final String COLOR_TABLE_BACKGROUND		= "COLOR_TABLE_BACKGROUND";
	public static final String COLOR_TABLE_ROW_LINE_COCOA	= "COLOR_TABLE_ROW_LINE_COCOA";
	public static final String COLOR_LAYER_ROW_BACKGROUND	= "COLOR_LAYER_ROW_BACKGROUND";

	public static final String COLOR_SWITCH_BORDER_COCOA_BLUE_TL	= "COLOR_SWITCH_BORDER_COCOA_BLUE_TL";
	public static final String COLOR_SWITCH_BORDER_COCOA_BLUE_BR	= "COLOR_SWITCH_BORDER_COCOA_BLUE_BR";
	public static final String COLOR_SWITCH_BORDER_COCOA_GRAY_TL	= "COLOR_SWITCH_BORDER_COCOA_GRAY_TL";
	public static final String COLOR_SWITCH_BORDER_COCOA_GRAY_BR	= "COLOR_SWITCH_BORDER_COCOA_GRAY_BR";
	public static final String COLOR_SWITCH_BORDER_LIGHT_GRAY_TL	= "COLOR_SWITCH_BORDER_LIGHT_GRAY_TL";
	public static final String COLOR_SWITCH_BORDER_LIGHT_GRAY_BR	= "COLOR_SWITCH_BORDER_LIGHT_GRAY_BR";


	public ColorRegistry getColorRegistry() {
		if (colorRegistry == null) {
			colorRegistry = createColorRegistry();
			initializeColorRegistry(colorRegistry);
		}
		return colorRegistry;
	}

	protected ColorRegistry createColorRegistry() {
		// AbstractUIPlugin#createImageRegistry と同じように ColorRegistry を作成する。

		if(Display.getCurrent() != null) {
			return new ColorRegistry(Display.getCurrent());
		}

		if(PlatformUI.isWorkbenchRunning()) {
			return new ColorRegistry(PlatformUI.getWorkbench().getDisplay());
		}

		throw new SWTError(SWT.ERROR_THREAD_INVALID_ACCESS);
	}

	protected void initializeColorRegistry(ColorRegistry reg) {
		reg.put(COLOR_TABLE_BACKGROUND, new RGB(192, 192, 192));
		reg.put(COLOR_TABLE_ROW_LINE_COCOA, new RGB(232, 232, 232));
		reg.put(COLOR_LAYER_ROW_BACKGROUND, new RGB(168, 168, 168));

		reg.put(COLOR_SWITCH_BORDER_COCOA_BLUE_TL, new RGB(47, 90, 145));
		reg.put(COLOR_SWITCH_BORDER_COCOA_BLUE_BR, new RGB(74, 142, 230));
		reg.put(COLOR_SWITCH_BORDER_COCOA_GRAY_TL, new RGB(153, 153, 153));
		reg.put(COLOR_SWITCH_BORDER_COCOA_GRAY_BR, new RGB(240, 240, 240));
		reg.put(COLOR_SWITCH_BORDER_LIGHT_GRAY_TL, new RGB(140, 140, 140));
		reg.put(COLOR_SWITCH_BORDER_LIGHT_GRAY_BR, new RGB(212, 212, 212));
	}

}
