/*
 * Copyright (c) 2009 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.app.views.layercomp;

import org.eclipse.swt.graphics.GC;

import ch.kuramo.javie.app.PropertyUtil;
import ch.kuramo.javie.app.project.DisableTimeRemapOperation;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.project.ProjectOperation;
import ch.kuramo.javie.core.AnimatableDouble;
import ch.kuramo.javie.core.LayerNature;
import ch.kuramo.javie.core.MediaLayer;

public class TimeRemapElement extends LayerAnimatableValueElement {

	public TimeRemapElement(LayerElement parent) {
		super(parent, parent.layer, "timeRemap", "タイムリマップ");
	}

	@Override
	protected AnimatableValueElementDelegate<?> createDelegate() {
		// TODO タイムコードで表示／入力する delegate を作る。
		AnimatableDouble avalue = PropertyUtil.getProperty(layer, property);
		return new AnimatableDoubleElementDelegate(this, name, avalue, unit) {
			@Override
			protected void drawValue(GC gc, int x, int y, int height, boolean focused) {
				if (LayerNature.isTimeRemapEnabled(layer)) {
					super.drawValue(gc, x, y, height, focused);
				}
			}
		};
	}

	@Override
	protected ProjectOperation createClearKeyframesOperation(ProjectManager pm) {
		return new DisableTimeRemapOperation(pm, (MediaLayer) layer);
	}

}
