/*
 * Copyright (c) 2009 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.core;

import ch.kuramo.javie.api.ColorMode;
import ch.kuramo.javie.api.Size2i;
import ch.kuramo.javie.api.Time;

public abstract class AbstractComposition implements Composition {

	private String _id;

	private ColorMode _colorMode;

	private Size2i _size;

	private Time _frameDuration;

	private Time _duration;


	public AbstractComposition() {
		super();
	}

	public void initialize(ColorMode colorMode, Size2i size, Time frameDuration, Time duration) {
		_id = Util.randomId();
		_colorMode = colorMode;
		_size = size;
		_frameDuration = frameDuration;
		_duration = duration;
	}

	public String getId() {
		return _id;
	}

	public void setId(String id) {
		_id = id;
	}

	public ColorMode getColorMode() {
		return _colorMode;
	}

	public void setColorMode(ColorMode colorMode) {
		_colorMode = colorMode;
	}

	public Size2i getSize() {
		return _size;
	}

	public void setSize(Size2i size) {
		_size = size;
	}

	public Time getFrameDuration() {
		return _frameDuration;
	}

	public void setFrameDuration(Time frameDuration) {
		_frameDuration = frameDuration;
	}

	public Time getDuration() {
		return _duration;
	}

	public void setDuration(Time duration) {
		_duration = duration;
	}

}
