/*
 * Copyright (c) 2009 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.core.internal.services;

import ch.kuramo.javie.api.plugin.PIArrayPools;
import ch.kuramo.javie.core.services.ArrayPools;

public class ArrayPoolsImpl implements ArrayPools, PIArrayPools {

	private final static ArrayPool<byte[]> _bytePool = ArrayPool.newBytePool();

	private final static ArrayPool<short[]> _shortPool = ArrayPool.newShortPool();

	private final static ArrayPool<int[]> _intPool = ArrayPool.newIntPool();

	private final static ArrayPool<float[]> _floatPool = ArrayPool.newFloatPool();


	public byte[] getByteArray(int length) {
		return _bytePool.get(length);
	}

	public short[] getShortArray(int length) {
		return _shortPool.get(length);
	}

	public int[] getIntArray(int length) {
		return _intPool.get(length);
	}

	public float[] getFloatArray(int length) {
		return _floatPool.get(length);
	}

	public void put(byte[] array) {
		_bytePool.put(array);
	}

	public void put(short[] array) {
		_shortPool.put(array);
	}

	public void put(int[] array) {
		_intPool.put(array);
	}

	public void put(float[] array) {
		_floatPool.put(array);
	}

	public void put(Object array) {
		if (array == null) {
			return;
		}

		if (array instanceof byte[]) {
			put((byte[]) array);
		} else if (array instanceof short[]) {
			put((short[]) array);
		} else if (array instanceof int[]) {
			put((int[]) array);
		} else if (array instanceof float[]) {
			put((float[]) array);
		} else {
			throw new IllegalArgumentException(
					"not array or unsupported array type: " + array.getClass().getName());
		}
	}

}
