/*
 * Copyright (c) 2009 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.core.services;

import org.mozilla.javascript.ContextFactory;

import ch.kuramo.javie.api.plugin.PIArrayPools;
import ch.kuramo.javie.api.plugin.PIAudioRenderContext;
import ch.kuramo.javie.api.plugin.PIShaderRegistry;
import ch.kuramo.javie.api.plugin.PIVideoRenderContext;
import ch.kuramo.javie.core.internal.services.AnimatableValueCollectorImpl;
import ch.kuramo.javie.core.internal.services.ArrayPoolsImpl;
import ch.kuramo.javie.core.internal.services.AudioEffectPipelineImpl;
import ch.kuramo.javie.core.internal.services.AudioRenderContextProxy;
import ch.kuramo.javie.core.internal.services.AudioRenderSupportImpl;
import ch.kuramo.javie.core.internal.services.EffectRegistryImpl;
import ch.kuramo.javie.core.internal.services.FontManagerProxy;
import ch.kuramo.javie.core.internal.services.GLGlobalImpl;
import ch.kuramo.javie.core.internal.services.MediaFileInputFactoryImpl;
import ch.kuramo.javie.core.internal.services.PIAudioRenderContextProxy;
import ch.kuramo.javie.core.internal.services.PIShaderRegistryImpl;
import ch.kuramo.javie.core.internal.services.PIVideoRenderContextProxy;
import ch.kuramo.javie.core.internal.services.ProjectDecoderImpl;
import ch.kuramo.javie.core.internal.services.ProjectElementFactoryImpl;
import ch.kuramo.javie.core.internal.services.ProjectEncoderImpl;
import ch.kuramo.javie.core.internal.services.ShaderRegistryImpl;
import ch.kuramo.javie.core.internal.services.SynchronousTaskThreadImpl;
import ch.kuramo.javie.core.internal.services.VideoEffectPipelineImpl;
import ch.kuramo.javie.core.internal.services.VideoRenderContextProxy;
import ch.kuramo.javie.core.internal.services.VideoRenderSupportImpl;

import com.google.inject.AbstractModule;
import com.google.inject.Scopes;

public class JavieCoreModule extends AbstractModule {

	@Override
	protected void configure() {

		// singlton

		bind(ProjectElementFactory.class)
				.to(ProjectElementFactoryImpl.class)
				.in(Scopes.SINGLETON);

		bind(ProjectEncoder.class)
				.to(ProjectEncoderImpl.class)
				.in(Scopes.SINGLETON);

		bind(ProjectDecoder.class)
				.to(ProjectDecoderImpl.class)
				.in(Scopes.SINGLETON);

		bind(MediaFileInputFactory.class)
				.to(MediaFileInputFactoryImpl.class)
				.in(Scopes.SINGLETON);

		bind(GLGlobal.class)
				.to(GLGlobalImpl.class)
				.in(Scopes.SINGLETON);

		bind(EffectRegistry.class)
				.to(EffectRegistryImpl.class)
				.in(Scopes.SINGLETON);

		bind(ShaderRegistry.class)
				.to(ShaderRegistryImpl.class)
				.in(Scopes.SINGLETON);

		bind(PIShaderRegistry.class)
				.to(PIShaderRegistryImpl.class)
				.in(Scopes.SINGLETON);

		bind(VideoRenderContext.class)
				.to(VideoRenderContextProxy.class)
				.in(Scopes.SINGLETON);

		bind(VideoRenderSupport.class)
				.to(VideoRenderSupportImpl.class)
				.in(Scopes.SINGLETON);

		bind(VideoEffectPipeline.class)
				.to(VideoEffectPipelineImpl.class)
				.in(Scopes.SINGLETON);

		bind(PIVideoRenderContext.class)
				.to(PIVideoRenderContextProxy.class)
				.in(Scopes.SINGLETON);

		bind(AudioRenderContext.class)
				.to(AudioRenderContextProxy.class)
				.in(Scopes.SINGLETON);

		bind(AudioRenderSupport.class)
				.to(AudioRenderSupportImpl.class)
				.in(Scopes.SINGLETON);

		bind(AudioEffectPipeline.class)
				.to(AudioEffectPipelineImpl.class)
				.in(Scopes.SINGLETON);

		bind(PIAudioRenderContext.class)
				.to(PIAudioRenderContextProxy.class)
				.in(Scopes.SINGLETON);

		bind(FontManager.class)
				.to(FontManagerProxy.class)
				.in(Scopes.SINGLETON);

		ArrayPoolsImpl arrayPools = new ArrayPoolsImpl();
		bind(ArrayPools.class)
				.toInstance(arrayPools);
		bind(PIArrayPools.class)
				.toInstance(arrayPools);

		bind(ContextFactory.class)
				.toInstance(new ContextFactory());


		// non-singleton

		bind(SynchronousTaskThread.class)
				.to(SynchronousTaskThreadImpl.class);

		bind(AnimatableValueCollector.class)
				.to(AnimatableValueCollectorImpl.class);
	}

}
