/*
 * Copyright (c) 2009 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.api.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
public @interface Effect {

	String id() default "";

	String category() default "";


	final String AUDIO				= "ch.kuramo.javie.api.effectCategory.audio";
	final String KEYING				= "ch.kuramo.javie.api.effectCategory.keying";
	final String STYLIZE			= "ch.kuramo.javie.api.effectCategory.stylize";
	final String DISTORT			= "ch.kuramo.javie.api.effectCategory.distort";
	final String TRANSITION			= "ch.kuramo.javie.api.effectCategory.transition";
	final String BLUR_AND_SHARPEN	= "ch.kuramo.javie.api.effectCategory.blurAndSharpen";
	final String UTILITY			= "ch.kuramo.javie.api.effectCategory.utility";
	final String COLOR_CORRECTION	= "ch.kuramo.javie.api.effectCategory.colorCorrection";

}
