/*
 * Copyright (c) 2009 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.app;

import java.util.Arrays;
import java.util.LinkedHashSet;

import javax.media.opengl.GLCapabilities;

import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.LinearUndoEnforcer;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;

import ch.kuramo.javie.app.player.GLCanvasFactory;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.services.GLGlobal;

public class ApplicationWorkbenchAdvisor extends WorkbenchAdvisor {

	public void initialize(IWorkbenchConfigurer configurer) {
		super.initialize(configurer);

		configurer.setSaveAndRestore(true);

		IOperationHistory history = configurer.getWorkbench().getOperationSupport().getOperationHistory();
		history.addOperationApprover(new LinearUndoEnforcer());


		if (Platform.getOS().equals(Platform.OS_WIN32)) {
			GLGlobal glGlobal = InjectorHolder.getInjector().getInstance(GLGlobal.class);

			// TODO これらの値を環境設定で変更できるようにする。
			int poolSize = 20;
			GLCapabilities canvasCap = glGlobal.getCanvasCapabilities();
			canvasCap.setDoubleBuffered(true);

			glGlobal.enterPoolMode(poolSize);
			glGlobal.setCanvasCapabilities(canvasCap);

			GLCanvasFactory.getFactory().enterPoolMode(poolSize);
		}

		Initializer.initialize();
	}

	public boolean preShutdown() {
		// Cmd+Qやメニューから終了しようとすると、
		// ApplicationWorkbenchWindowAdvisor.preWindowShellClose() が呼ばれないまま
		// このメソッドにやってくるようなので、ここでも保存の確認を行う。

		LinkedHashSet<IWorkbenchWindow> windows = Util.newLinkedHashSet();

		// アクティブウインドウが先頭に来るようにする。
		IWorkbench workbench = getWorkbenchConfigurer().getWorkbench();
		IWorkbenchWindow activeWindow = workbench.getActiveWorkbenchWindow();
		if (activeWindow != null) {
			windows.add(activeWindow);
		}

		// 残りのウインドウも表示順にしたいが、ウインドウの表示順を取得する方法が不明なので順不同（たぶん生成順）
		windows.addAll(Arrays.asList(workbench.getWorkbenchWindows()));

		for (IWorkbenchWindow window : windows) {
			ProjectManager pm = ProjectManager.forWorkbenchWindow(window);
			if (pm != null && ApplicationWorkbenchWindowAdvisor.saveConfirmationRequired(window)) {
				switch (SaveUtil.saveIfDirty(pm)) {
					case NOT_DIRTY:
					case SAVED:
					case UNSAVED:
						continue;
					default:
						return false;
				}
			}
		}

		return true;
	}

	public WorkbenchWindowAdvisor createWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
		return new ApplicationWorkbenchWindowAdvisor(configurer);
	}

	public String getInitialWindowPerspectiveId() {
		return Perspective.ID;
	}

}
