/*
 * Copyright (c) 2009 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.app;

import org.eclipse.ui.IWorkbenchCommandConstants;

public final class CommandIds {

	public static final String NEW_PROJECT = "ch.kuramo.javie.app.commands.newProject";

	public static final String NEW_COMPOSITION = "ch.kuramo.javie.app.commands.newComposition";

	public static final String NEW_SOLID_COLOR_ITEM = "ch.kuramo.javie.app.commands.newSolidColorItem";

	public static final String NEW_FILE_ITEMS = "ch.kuramo.javie.app.commands.newFileItems";

	public static final String NEW_FOLDER = "ch.kuramo.javie.app.commands.newFolder";

	public static final String OPEN_PROJECT = "ch.kuramo.javie.app.commands.openProject";

	public static final String SAVE = IWorkbenchCommandConstants.FILE_SAVE;

	public static final String SAVE_AS = IWorkbenchCommandConstants.FILE_SAVE_AS;

	public static final String SAVE_COPY = "ch.kuramo.javie.app.commands.saveCopy";

	public static final String SEQUENCE_OUTPUT = "ch.kuramo.javie.app.commands.sequenceOutput";

	public static final String WAVE_OUTPUT = "ch.kuramo.javie.app.commands.waveOutput";


	public static final String UNDO = IWorkbenchCommandConstants.EDIT_UNDO;

	public static final String REDO = IWorkbenchCommandConstants.EDIT_REDO;


	public static final String NEW_CAMERA_LAYER = "ch.kuramo.javie.app.commands.newCameraLayer";

	public static final String NEW_NULL_LAYER = "ch.kuramo.javie.app.commands.newNullLayer";

	public static final String NEW_TEXT_LAYER = "ch.kuramo.javie.app.commands.newTextLayer";


	public static final String SHOW_PROJECT_VIEW = "ch.kuramo.javie.app.commands.showProjectView";

	public static final String SHOW_CONSOLE_VIEW = "ch.kuramo.javie.app.commands.showConsoleView";


	private CommandIds() { }

}
