/*
 * Copyright (c) 2009 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.app;

import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;

import ch.kuramo.javie.app.views.LayerCompositionView;
import ch.kuramo.javie.app.views.MediaPlayerView;
import ch.kuramo.javie.app.views.ProjectView;

public class Perspective implements IPerspectiveFactory {

	public static final String ID = "ch.kuramo.javie.app.perspective";

	public static final String ID_BOTTOM_FOLDER = "ch.kuramo.javie.app.perspective.bottomFolder";

	public static final String ID_LEFT_FOLDER = "ch.kuramo.javie.app.perspective.leftFolder";

	public static final String ID_CENTER_FOLDER = "ch.kuramo.javie.app.perspective.centerFolder";


	public void createInitialLayout(IPageLayout layout) {
		String editorArea = layout.getEditorArea();

		IFolderLayout bottomFolder = layout.createFolder(
				ID_BOTTOM_FOLDER, IPageLayout.BOTTOM, 0.5f, editorArea);

		IFolderLayout leftFolder = layout.createFolder(
				ID_LEFT_FOLDER, IPageLayout.LEFT, 0.2f, editorArea);

		IFolderLayout centerFolder = layout.createFolder(
				ID_CENTER_FOLDER, IPageLayout.LEFT, 0.95f, editorArea);

		leftFolder.addView(ProjectView.ID);
		bottomFolder.addPlaceholder("org.eclipse.ui.console.ConsoleView");
		bottomFolder.addPlaceholder(LayerCompositionView.ID + ":*");
		centerFolder.addPlaceholder(MediaPlayerView.ID + ":*");

		layout.setEditorAreaVisible(false);
	}

}
