/*
 * Copyright (c) 2009 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.app;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;

public class UIUtil {

	public static <T extends IViewPart> T showView(IWorkbenchPage page, String viewId) {
		return showView(page, viewId, null, IWorkbenchPage.VIEW_ACTIVATE);
	}

	public static <T extends IViewPart> T showView(IWorkbenchPage page, String viewId, String secondaryId, int mode) {
		try {
			@SuppressWarnings("unchecked")
			T viewPart = (T) page.showView(viewId, secondaryId, mode);
			return viewPart;
		} catch (PartInitException e) {
			errorDialog(page, "Error", e);
			return null;
		}
	}

	public static <T extends IViewPart> T findView(IWorkbenchPage page, String viewId) {
		@SuppressWarnings("unchecked")
		T viewPart = (T) page.findView(viewId);
		return viewPart;
	}

	public static <T extends IViewPart> T findView(IWorkbenchPage page, String viewId, String secondaryId) {
		IViewReference viewRef = page.findViewReference(viewId, secondaryId);
		if (viewRef != null) {
			@SuppressWarnings("unchecked")
			T viewPart = (T) viewRef.getView(true);
			return viewPart;
		}
		return null;
	}

	public static void hideView(IWorkbenchPage page, IViewPart view) {
		page.hideView(view);
	}


	public static void errorDialog(Shell shell, String title, Throwable t) {
		MessageDialog.openError(shell, title, t.getMessage());
	}

	public static void errorDialog(IWorkbenchWindow window, String title, Throwable t) {
		errorDialog(window.getShell(), title, t);
	}

	public static void errorDialog(IWorkbenchPage page, String title, Throwable t) {
		errorDialog(page.getWorkbenchWindow(), title, t);
	}


	private UIUtil() { }

}
