/*
 * Copyright (c) 2009 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.app.actions;

import java.io.File;

import org.eclipse.jface.action.Action;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IWorkbenchWindow;

import ch.kuramo.javie.app.CommandIds;
import ch.kuramo.javie.app.SaveUtil;
import ch.kuramo.javie.app.UIUtil;
import ch.kuramo.javie.app.project.ProjectManager;

public class OpenProjectAction extends Action {

	private final IWorkbenchWindow window;

	public OpenProjectAction(IWorkbenchWindow window) {
		super("プロジェクトを開く...");
		this.window = window;

		setId(CommandIds.OPEN_PROJECT);
		setActionDefinitionId(CommandIds.OPEN_PROJECT);
		//setImageDescriptor(Activator.getImageDescriptor("/icons/open_project.png"));
	}

	public void run() {
		ProjectManager pm = ProjectManager.forWorkbenchWindow(window);
		if (pm != null) {
			switch (SaveUtil.saveIfDirty(pm)) {
				case NOT_DIRTY:
				case SAVED:
				case UNSAVED:
					break;
				default:
					return;
			}
		}

		File file = showFileDialog();
		if (file == null) {
			return;
		}

		if (pm != null) {
			pm.dispose();
			pm = null;
		}

		try {
			pm = ProjectManager.openProject(file, window);
		} catch (Exception e) {
			UIUtil.errorDialog(window, "Error", e);
			pm = ProjectManager.newProject(window);
		}
	}

	private File showFileDialog() {
		String[] filterNames = new String[] { "Javie Project Files", "All Files (*)" };
		String[] filterExtensions = new String[] { "*.jvp", "*" };

		String platform = SWT.getPlatform();
		if (platform.equals("win32") || platform.equals("wpf")) {
			filterNames = new String[] { "Javie Project Files", "All Files (*.*)" };
			filterExtensions = new String[] { "*.jvp", "*.*" };
		}

		FileDialog dialog = new FileDialog(window.getShell(), SWT.OPEN | SWT.SHEET);
		dialog.setFilterNames(filterNames);
		dialog.setFilterExtensions(filterExtensions);

		String path = dialog.open();
		return (path != null) ? new File(path) : null;
	}

}
