/*
 * Copyright (c) 2009 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.app.project;

import ch.kuramo.javie.api.Vec3d;
import ch.kuramo.javie.core.CameraLayer;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.services.ProjectElementFactory;

public class NewCameraLayerOperation extends AbstractNewLayerOperation<CameraLayer> {

	public NewCameraLayerOperation(ProjectManager projectManager, LayerComposition comp) {
		super(projectManager, comp, "新規カメラ");
	}

	@Override
	protected CameraLayer createNewLayer(
			ProjectManager projectManager, LayerComposition comp, ProjectElementFactory factory) {

		CameraLayer cameraLayer = factory.newCameraLayer();
		cameraLayer.setName(projectManager.getUnusedLayerName(comp, "カメラ"));

		double w = comp.getSize().width;
		double h = comp.getSize().height;
		double fovx = 39.6;
		double zoom = w / (2 * Math.tan(Math.toRadians(fovx/2)));
		cameraLayer.getZoom().clearKeyframes(zoom);
		cameraLayer.getNear().clearKeyframes(zoom / 2);
		cameraLayer.getFar().clearKeyframes(zoom * 10);
		cameraLayer.getPosition().clearKeyframes(new Vec3d(w/2, h/2, -zoom));
		cameraLayer.getPointOfInterest().clearKeyframes(new Vec3d(w/2, h/2));

		return cameraLayer;
	}

}
