/*
 * Copyright (c) 2009 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.app.wizards;

import java.lang.reflect.InvocationTargetException;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IWorkbenchPage;

import ch.kuramo.javie.app.UIUtil;
import ch.kuramo.javie.app.player.PlayerLock;
import ch.kuramo.javie.app.project.NewLayerCompositionOperation;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.views.LayerCompositionView;
import ch.kuramo.javie.app.views.MediaPlayerView;
import ch.kuramo.javie.core.Folder;
import ch.kuramo.javie.core.JavieRuntimeException;

public class CompositionWizard extends Wizard {

	private static CompositionSettings _defaultSettings = new CompositionSettings();


	private final ProjectManager _projectManager;

	private final Folder _parent;

	private CompositionWizardPage _page;


	public CompositionWizard(ProjectManager projectManager, Folder parent) {
		super();
		_projectManager = projectManager;
		_parent = parent;
		setWindowTitle("新規コンポジション");
	}

	public void addPages() {
		CompositionSettings settings = _defaultSettings.clone();
		settings.name = _projectManager.getUnusedItemName("コンポ");

		_page = new CompositionWizardPage(settings);
		addPage(_page);
	}

	public boolean performFinish() {
		CompositionSettings settings = _page.getResult();
		if (settings == null) {
			return false;
		}

		NewLayerCompositionOperation op = new NewLayerCompositionOperation(
				_projectManager, _parent, settings.name, settings.width, settings.height,
				settings.frameDuration, settings.duration, settings.colorMode);

		_projectManager.postOperation(op);

		String compItemId = op.getCompositionItemId();

		if (waitShadowOperation(compItemId)) {
			IWorkbenchPage page = _projectManager.getWorkbenchWindow().getActivePage();
			UIUtil.showView(page, LayerCompositionView.ID, compItemId, IWorkbenchPage.VIEW_ACTIVATE);
			UIUtil.showView(page, MediaPlayerView.ID, compItemId, IWorkbenchPage.VIEW_VISIBLE);
		}

		_defaultSettings = settings;
		return true;
	}

	private boolean waitShadowOperation(final String compItemId) {
		final boolean[] ready = new boolean[1];

		IRunnableWithProgress runnable = new IRunnableWithProgress() {
			public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
				for (int i = 0; i < 100; ++i) {
					try { Thread.sleep(100); } catch (InterruptedException e) { }

					PlayerLock.readLock().lock();
					try {
						if (_projectManager.getShadow().getItem(compItemId) != null) {
							ready[0] = true;
							break;
						}
					} finally {
						PlayerLock.readLock().unlock();
					}
				}
			}
		};

		try {
			getContainer().run(false, false, runnable);
		} catch (InvocationTargetException e) {
			throw new JavieRuntimeException(e);
		} catch (InterruptedException e) {
			throw new JavieRuntimeException(e);
		}

		return ready[0];
	}

}
