/*
 * Copyright (c) 2009 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.core;

import net.arnx.jsonic.JSONHint;

import org.mozilla.javascript.Scriptable;

import ch.kuramo.javie.api.Vec3d;

public abstract class AbstractTransformableLayer extends AbstractLayer implements TransformableLayer {

	private boolean _threeD;

	private AnimatableVec3d _anchorPoint;

	private AnimatableVec3d _position;

	private AnimatableVec3d _scale;

	private AnimatableVec3d _orientation;

	private AnimatableDouble _rotationX;

	private AnimatableDouble _rotationY;

	private AnimatableDouble _rotationZ;


	@Override
	protected void initialize(String name) {
		super.initialize(name);

		_anchorPoint = new AnimatableVec3d(new Vec3d(0, 0, 0));
		_position = new AnimatableVec3d(new Vec3d(0, 0, 0));
		_scale = new AnimatableVec3d(new Vec3d(100, 100, 100));
		_orientation = new AnimatableVec3d(new Vec3d(0, 0, 0));
		_rotationX = new AnimatableDouble(0d);
		_rotationY = new AnimatableDouble(0d);
		_rotationZ = new AnimatableDouble(0d);
	}

	@JSONHint(name="3D")
	public boolean isThreeD() {
		return _threeD;
	}

	@JSONHint(name="3D")
	public void setThreeD(boolean threeD) {
		_threeD = threeD;
	}

	public AnimatableVec3d getAnchorPoint() {
		return _anchorPoint;
	}

	public void setAnchorPoint(AnimatableVec3d anchorPoint) {
		_anchorPoint = anchorPoint;
	}

	public AnimatableVec3d getPosition() {
		return _position;
	}

	public void setPosition(AnimatableVec3d position) {
		_position = position;
	}

	public AnimatableVec3d getScale() {
		return _scale;
	}

	public void setScale(AnimatableVec3d scale) {
		_scale = scale;
	}

	public AnimatableVec3d getOrientation() {
		return _orientation;
	}

	public void setOrientation(AnimatableVec3d orientation) {
		_orientation = orientation;
	}

	public AnimatableDouble getRotationX() {
		return _rotationX;
	}

	public void setRotationX(AnimatableDouble rotationX) {
		_rotationX = rotationX;
	}

	public AnimatableDouble getRotationY() {
		return _rotationY;
	}

	public void setRotationY(AnimatableDouble rotationY) {
		_rotationY = rotationY;
	}

	public AnimatableDouble getRotationZ() {
		return _rotationZ;
	}

	public void setRotationZ(AnimatableDouble rotationZ) {
		_rotationZ = rotationZ;
	}

	@Override
	public void prepareExpression(ExpressionScope scope) {
		super.prepareExpression(scope);

		scope.assignTo(_anchorPoint);
		scope.assignTo(_position);
		scope.assignTo(_scale);
		scope.assignTo(_orientation);
		scope.assignTo(_rotationX);
		scope.assignTo(_rotationY);
		scope.assignTo(_rotationZ);
	}


	public class TransformableLayerExpressionElement extends LayerExpressionElement {

		public TransformableLayerExpressionElement(RenderContext renderContext) {
			super(renderContext);
		}

		public Scriptable[] getAnchorPoint()	{ return elem(_anchorPoint); }
		public Scriptable[] getPosition()		{ return elem(_position); }
		public Scriptable[] getScale()			{ return elem(_scale); }
		public Scriptable[] getOrientation()	{ return elem(_orientation); }
		public Scriptable getRotationX()		{ return elem(_rotationX); }
		public Scriptable getRotationY()		{ return elem(_rotationY); }
		public Scriptable getRotationZ()		{ return elem(_rotationZ); }
		public Scriptable getRotation()			{ return getRotationZ(); }
	}

}
