/*
 * Copyright (c) 2009 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.core.internal.services;

import ch.kuramo.javie.api.AudioMode;
import ch.kuramo.javie.core.WrappedOperation;
import ch.kuramo.javie.core.services.AudioRenderContext;

public class AudioRenderContextImpl extends AbstractRenderContext implements AudioRenderContext {

	private AudioMode _audioMode;

	private int _frameCount;


	public void deactivate() {
		_audioMode = null;
		_frameCount = 0;

		super.deactivate();
	}

	public void reset() {
		super.reset();

		_audioMode = null;
		_frameCount = 0;
	}

	public <T> T saveAndExecute(WrappedOperation<T> operation) {
		int frameCount = _frameCount;
		try {
			return super.saveAndExecute(operation);
		} finally {
			_frameCount = frameCount;
		}
	}

	public AudioMode getAudioMode() {
		if (_audioMode == null) {
			throw new IllegalStateException("audioMode is not set.");
		}
		return _audioMode;
	}

	public void setAudioMode(AudioMode audioMode) {
		if (_audioMode != null) {
			throw new IllegalStateException("audioMode has already been set.");
		}
		_audioMode = audioMode;
	}

	public int getFrameCount() {
		return _frameCount;
	}

	public void setFrameCount(int count) {
		_frameCount = count;
	}

}
