package ftgl;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.ptr.DoubleByReference;

public interface FTGL extends Library {

	static final String libname = "ftgl";

	static final FTGL instance = (FTGL) Native.loadLibrary(libname, FTGL.class);



	////////////////////////////////////////////////////////////////////////////////
	// freetype constants                                                         //
	////////////////////////////////////////////////////////////////////////////////

	public static final int FT_ENCODING_UNICODE = 1970170211;	// 'unic'


	////////////////////////////////////////////////////////////////////////////////
	// ftgl.h                                                                     //
	////////////////////////////////////////////////////////////////////////////////


	static final int FTGL_RENDER_FRONT = 0x0001;
	static final int FTGL_RENDER_BACK  = 0x0002;
	static final int FTGL_RENDER_SIDE  = 0x0004;
	static final int FTGL_RENDER_ALL   = 0xffff;

	static final int FTGL_ALIGN_LEFT    = 0;
	static final int FTGL_ALIGN_CENTER  = 1;
	static final int FTGL_ALIGN_RIGHT   = 2;
	static final int FTGL_ALIGN_JUSTIFY = 3;



	////////////////////////////////////////////////////////////////////////////////
	// FTGlyph.h                                                                  //
	////////////////////////////////////////////////////////////////////////////////


//	/**
//	 * Create a custom FTGL glyph object.
//	 * 
//	 * FTGLglyph *ftglCreateCustomGlyph(FTGLglyph *base, void *data,
//	 *                  void(*renderCallback)(FTGLglyph *, void *, FTGL_DOUBLE, FTGL_DOUBLE, int, FTGL_DOUBLE *, FTGL_DOUBLE *),
//	 *                  void(*destroyCallback)(FTGLglyph *, void *))
//	 */


	/**
	 * Destroy an FTGL glyph object.
	 * 
	 * void ftglDestroyGlyph(FTGLglyph *glyph)
	 */
	void ftglDestroyGlyph(FTGLglyph glyph);


	/**
	 * Render a glyph at the current pen position and compute the corresponding advance.
	 * 
	 * void ftglRenderGlyph(FTGLglyph *glyph, FTGL_DOUBLE penx, FTGL_DOUBLE peny,
	 *              int renderMode, FTGL_DOUBLE *advancex, FTGL_DOUBLE *advancey)
	 */
	void ftglRenderGlyph(FTGLglyph glyph, double penx, double peny,
					int renderMode, double[] advancex, double[] advancey);

	void ftglRenderGlyph(FTGLglyph glyph, double penx, double peny,
					int renderMode, DoubleByReference advancex, DoubleByReference advancey);


	/**
	 * Return the advance for a glyph.
	 * 
	 * float ftglGetGlyphAdvance(FTGLglyph *glyph)
	 */
	float ftglGetGlyphAdvance(FTGLglyph glyph);


	/**
	 * Return the bounding box for a glyph.
	 * 
	 * void ftglGetGlyphBBox(FTGLglyph *glyph, float bounds[6])
	 */
	void ftglGetGlyphBBox(FTGLglyph glyph, float[] bounds);


	/**
	 * Query a glyph for errors.
	 * 
	 * FT_Error ftglGetGlyphError(FTGLglyph *glyph)
	 */
	int ftglGetGlyphError(FTGLglyph glyph);



	////////////////////////////////////////////////////////////////////////////////
	// FTBitmapGlyph.h                                                            //
	// FTExtrdGlyph.h                                                             //
	// FTOutlineGlyph.h                                                           //
	// FTPixmapGlyph.h                                                            //
	// FTPolyGlyph.h                                                              //
	// FTTextureGlyph.h                                                           //
	////////////////////////////////////////////////////////////////////////////////


//	/**
//	 * FTGLglyph *ftglCreateBitmapGlyph(FT_GlyphSlot glyph)
//	 */
//
//
//	/**
//	 * FTGLglyph *ftglCreateExtrudeGlyph(FT_GlyphSlot glyph, float depth,
//	 *                  float frontOutset, float backOutset, int useDisplayList)
//	 */
//
//
//	/**
//	 * FTGLglyph *ftglCreateOutlineGlyph(FT_GlyphSlot glyph, float outset, int useDisplayList)
//	 */
//
//
//	/**
//	 * FTGLglyph *ftglCreatePixmapGlyph(FT_GlyphSlot glyph)
//	 */
//	
//
//	/**
//	 * FTGLglyph *ftglCreatePolygonGlyph(FT_GlyphSlot glyph, float outset, int useDisplayList)
//	 */
//
//
//	/**
//	 * FTGLglyph *ftglCreateTextureGlyph(FT_GlyphSlot glyph, int id,
//	 *                  int xOffset, int yOffset, int width, int height)
//	 */



	////////////////////////////////////////////////////////////////////////////////
	// FTFont.h                                                                   //
	////////////////////////////////////////////////////////////////////////////////


//	/**
//	 * Create a custom FTGL font object.
//	 * 
//	 * FTGLfont *ftglCreateCustomFont(char const *fontFilePath, void *data,
//	 *                  FTGLglyph *(*makeglyphCallback)(FT_GlyphSlot, void *))
//	 */


	/**
	 * Destroy an FTGL font object.
	 * 
	 * void ftglDestroyFont(FTGLfont *font)
	 */
	void ftglDestroyFont(FTGLfont font);


	/**
	 * Attach auxilliary file to font e.g.
	 * 
	 * int ftglAttachFile(FTGLfont *font, const char *path)
	 */
	int ftglAttachFile(FTGLfont font, String path);


//	/**
//	 * Attach auxilliary data to font, e.g.
//	 * 
//	 * int ftglAttachData(FTGLfont *font, const unsigned char *data, size_t size)
//	 */


	/**
	 * Set the character map for the face.
	 * 
	 * int ftglSetFontCharMap(FTGLfont *font, FT_Encoding encoding)
	 */
	int ftglSetFontCharMap(FTGLfont font, int encoding);


	/**
	 * Get the number of character maps in this face.
	 * 
	 * unsigned int ftglGetFontCharMapCount(FTGLfont *font)
	 */
	int ftglGetFontCharMapCount(FTGLfont font);


	/**
	 * Get a list of character maps in this face.
	 * 
	 * FT_Encoding *ftglGetFontCharMapList(FTGLfont *font)
	 */
	int ftglGetFontCharMapList(FTGLfont font);


	/**
	 * Set the char size for the current face.
	 * 
	 * int ftglSetFontFaceSize(FTGLfont *font, unsigned int size, unsigned int res)
	 */
	int ftglSetFontFaceSize(FTGLfont font, int size, int res);


	/**
	 * Get the current face size in points (1/72 inch).
	 * 
	 * unsigned int ftglGetFontFaceSize(FTGLfont *font)
	 */
	int ftglGetFontFaceSize(FTGLfont font);


	/**
	 * Set the extrusion distance for the font.
	 * 
	 * void ftglSetFontDepth(FTGLfont *font, float depth)
	 */
	void ftglSetFontDepth(FTGLfont font, float depth);


	/**
	 * Set the outset distance for the font.
	 * 
	 * void ftglSetFontOutset(FTGLfont *font, float front, float back)
	 */
	void ftglSetFontOutset(FTGLfont font, float front, float back);


	/**
	 * Enable or disable the use of Display Lists inside FTGL.
	 * 
	 * void ftglSetFontDisplayList(FTGLfont *font, int useList)
	 */
	void ftglSetFontDisplayList(FTGLfont font, int useList);


	/**
	 * Get the global ascender height for the face.
	 * 
	 * float ftglGetFontAscender(FTGLfont *font)
	 */
	float ftglGetFontAscender(FTGLfont font);


	/**
	 * Gets the global descender height for the face.
	 * 
	 * float ftglGetFontDescender(FTGLfont *font)
	 */
	float ftglGetFontDescender(FTGLfont font);


	/**
	 * Gets the line spacing for the font.
	 * 
	 * float ftglGetFontLineHeight(FTGLfont *font)
	 */
	float ftglGetFontLineHeight(FTGLfont font);


	/**
	 * Get the bounding box for a string.
	 * 
	 * void ftglGetFontBBox(FTGLfont *font, const char *string, int len, float bounds[6])
	 */
	void ftglGetFontBBox(FTGLfont font, String string, int len, float bounds[]);


	/**
	 * Get the advance width for a string
	 * 
	 * float ftglGetFontAdvance(FTGLfont *font, const char *string)
	 */
	float ftglGetFontAdvance(FTGLfont font, String string);


	/**
	 * Render a string of characters.
	 * 
	 * void ftglRenderFont(FTGLfont *font, const char *string, int mode)
	 */
	void ftglRenderFont(FTGLfont font, String string, int mode);


	/**
	 * Query a font for errors.
	 * 
	 * FT_Error ftglGetFontError(FTGLfont *font)
	 */
	int ftglGetFontError(FTGLfont font);



	////////////////////////////////////////////////////////////////////////////////
	// FTGLBitmapFont.h                                                           //
	// FTBufferFont.h                                                             //
	// FTGLExtrdFont.h                                                            //
	// FTGLOutlineFont.h                                                          //
	// FTGLPixmapFont.h                                                           //
	// FTGLPolygonFont.h                                                          //
	// FTGLTextureFont.h                                                          //
	////////////////////////////////////////////////////////////////////////////////


	/**
	 * Open and read a font file. 
	 * 
	 * FTGLfont *ftglCreateBitmapFont(const char *file)
	 */
	FTGLfont ftglCreateBitmapFont(String file);


	/**
	 * Open and read a font file.
	 * 
	 * FTGLfont *ftglCreateBufferFont(const char *file)
	 */
	FTGLfont ftglCreateBufferFont(String file);


	/**
	 * Open and read a font file.
	 * 
	 * FTGLfont *ftglCreateExtrudeFont(const char *file)
	 */
	FTGLfont ftglCreateExtrudeFont(String file);


	/**
	 * Open and read a font file.
	 * 
	 * FTGLfont *ftglCreateOutlineFont(const char *file)
	 */
	FTGLfont ftglCreateOutlineFont(String file);


	/**
	 * Open and read a font file.
	 * 
	 * FTGLfont *ftglCreatePixmapFont(const char *file)
	 */
	FTGLfont ftglCreatePixmapFont(String file);


	/**
	 * Open and read a font file.
	 * 
	 * FTGLfont *ftglCreatePolygonFont(const char *file)
	 */
	FTGLfont ftglCreatePolygonFont(String file);


	/**
	 * Open and read a font file.
	 * 
	 * FTGLfont *ftglCreateTextureFont(const char *file)
	 */
	FTGLfont ftglCreateTextureFont(String file);



	////////////////////////////////////////////////////////////////////////////////
	// FTLayout.h                                                                 //
	////////////////////////////////////////////////////////////////////////////////


	/**
	 * Destroy an FTGL layout object.
	 * 
	 * void ftglDestroyLayout(FTGLlayout *layout)
	 */
	void ftglDestroyLayout(FTGLlayout layout);


	/**
	 * Get the bounding box for a string.
	 * 
	 * void ftglGetLayoutBBox(FTGLlayout *layout, const char *string, float bounds[6])
	 */
	void ftglGetLayoutBBox(FTGLlayout layout, String string, float[] bounds);


	/**
	 * Render a string of characters.
	 * 
	 * void ftglRenderLayout(FTGLlayout *layout, const char *string, int mode)
	 */
	void ftglRenderLayout(FTGLlayout layout, String string, int mode);


	/**
	 * Query a layout for errors.
	 * 
	 * FT_Error ftglGetLayoutError (FTGLlayout *layout)
	 */
	int ftglGetLayoutError (FTGLlayout layout);



	////////////////////////////////////////////////////////////////////////////////
	// FTSimpleLayout.h                                                           //
	////////////////////////////////////////////////////////////////////////////////


	/**
	 * FTGLlayout *ftglCreateSimpleLayout(void)
	 */
	FTGLlayout ftglCreateSimpleLayout();


	/**
	 * void ftglSetLayoutFont(FTGLlayout *, FTGLfont*)
	 */
	void ftglSetLayoutFont(FTGLlayout layout, FTGLfont fontInit);


	/**
	 * FTGLfont *ftglGetLayoutFont(FTGLlayout *)
	 */
	FTGLfont ftglGetLayoutFont(FTGLlayout layout);


	/**
	 * void ftglSetLayoutLineLength(FTGLlayout *, const float)
	 */
	void ftglSetLayoutLineLength(FTGLlayout layout, float lineLength);


	/**
	 * float ftglGetLayoutLineLength(FTGLlayout *)
	 */
	float ftglGetLayoutLineLength(FTGLlayout layout);


	/**
	 * void ftglSetLayoutAlignment(FTGLlayout *, const int)
	 */
	void ftglSetLayoutAlignment(FTGLlayout layout, int alignment);


	/**
	 * int ftglGetLayoutAlignement(FTGLlayout *)
	 */
	int ftglGetLayoutAlignement(FTGLlayout layout);


	/**
	 * void ftglSetLayoutLineSpacing(FTGLlayout *, const float)
	 */
	void ftglSetLayoutLineSpacing(FTGLlayout layout, float lineSpacing);


	/**
	 * float ftglGetLayoutLineSpacing(FTGLlayout *)
	 */
	float ftglGetLayoutLineSpacing(FTGLlayout layout);


}
