/*
 * Copyright (c) 2009 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.effects.keying;

import ch.kuramo.javie.api.annotations.GLProgram;
import ch.kuramo.javie.api.annotations.GLShader;
import ch.kuramo.javie.api.annotations.GLShader.ShaderType;

public class KeyingShaders {

	@GLShader(ShaderType.FRAGMENT_SHADER)
	@GLProgram
	public static final String[] BLUE_SCREEN_KEY = {
		"uniform sampler2DRect texture;",
		"uniform float threshold;",
		"uniform float t_minus_c;",
		"",
		"void main(void)",
		"{",
		"	vec4 color = texture2DRect(texture, gl_TexCoord[0].st);",
		"	vec3 rgb = color.rgb/color.a;",
		"	color.a = min(color.a, color.a*(threshold-rgb.b*(1.0-rgb.r))/t_minus_c);",
		"	rgb.b = min(rgb.b, rgb.g);",
		"	gl_FragColor = vec4(rgb, 1.0)*color.a;",
		"}"
	};

	@GLShader(ShaderType.FRAGMENT_SHADER)
	@GLProgram
	public static final String[] BLUE_SCREEN_KEY_MASK_ONLY = {
		"uniform sampler2DRect texture;",
		"uniform float threshold;",
		"uniform float t_minus_c;",
		"",
		"void main(void)",
		"{",
		"	vec4 color = texture2DRect(texture, gl_TexCoord[0].st);",
		"	vec3 rgb = color.rgb/color.a;",
		"	float a = min(color.a, color.a*(threshold-rgb.b*(1.0-rgb.r))/t_minus_c);",
		"	gl_FragColor = vec4(a, a, a, 1.0);",
		"}"
	};

	@GLShader(ShaderType.FRAGMENT_SHADER)
	@GLProgram
	public static final String[] GREEN_SCREEN_KEY = {
		"uniform sampler2DRect texture;",
		"uniform float threshold;",
		"uniform float t_minus_c;",
		"",
		"void main(void)",
		"{",
		"	vec4 color = texture2DRect(texture, gl_TexCoord[0].st);",
		"	vec3 rgb = color.rgb/color.a;",
		"	color.a = min(color.a, color.a*(threshold-rgb.g*(1.0-rgb.r))/t_minus_c);",
		"	rgb.g = min(rgb.g, rgb.r);",
		"	gl_FragColor = vec4(rgb, 1.0)*color.a;",
		"}"
	};

	@GLShader(ShaderType.FRAGMENT_SHADER)
	@GLProgram
	public static final String[] GREEN_SCREEN_KEY_MASK_ONLY = {
		"uniform sampler2DRect texture;",
		"uniform float threshold;",
		"uniform float t_minus_c;",
		"",
		"void main(void)",
		"{",
		"	vec4 color = texture2DRect(texture, gl_TexCoord[0].st);",
		"	vec3 rgb = color.rgb/color.a;",
		"	float a = min(color.a, color.a*(threshold-rgb.g*(1.0-rgb.r))/t_minus_c);",
		"	gl_FragColor = vec4(a, a, a, 1.0);",
		"}"
	};

	@GLShader(ShaderType.FRAGMENT_SHADER)
	@GLProgram
	public static final String[] SMOOTHING_LOW = {
		"uniform sampler2DRect texture;",
		"",
		"void main(void)",
		"{",
		"	vec2 coord = gl_TexCoord[0].st;",
		"	vec4 sum = vec4(0.0);",
		"	int n = 0;",
		"	vec4 c;",
		"	c = texture2DRect(texture, coord+vec2(-1.0, -1.0)); if (c.a != 0.0) { ++n; sum += 0.0625 * c; }",
		"	c = texture2DRect(texture, coord+vec2( 0.0, -1.0)); if (c.a != 0.0) { ++n; sum += 0.1250 * c; }",
		"	c = texture2DRect(texture, coord+vec2( 1.0, -1.0)); if (c.a != 0.0) { ++n; sum += 0.0625 * c; }",
		"	c = texture2DRect(texture, coord+vec2(-1.0,  0.0)); if (c.a != 0.0) { ++n; sum += 0.1250 * c; }",
		"	c = texture2DRect(texture, coord+vec2( 1.0,  0.0)); if (c.a != 0.0) { ++n; sum += 0.1250 * c; }",
		"	c = texture2DRect(texture, coord+vec2(-1.0,  1.0)); if (c.a != 0.0) { ++n; sum += 0.0625 * c; }",
		"	c = texture2DRect(texture, coord+vec2( 0.0,  1.0)); if (c.a != 0.0) { ++n; sum += 0.1250 * c; }",
		"	c = texture2DRect(texture, coord+vec2( 1.0,  1.0)); if (c.a != 0.0) { ++n; sum += 0.0625 * c; }",
		"	c = texture2DRect(texture, coord                 ); if (c.a != 0.0) { ++n; sum += 0.2500 * c; }",
		"",
		"	gl_FragColor = (n > 0 && n < 9) ? sum : c;",
		"}"
	};

	@GLShader(ShaderType.FRAGMENT_SHADER)
	@GLProgram
	public static final String[] SMOOTHING_HIGH = {
		"uniform sampler2DRect texture;",
		"",
		"void main(void)",
		"{",
		"	vec2 coord = gl_TexCoord[0].st;",
		"	vec4 sum = vec4(0.0);",
		"	int n = 0;",
		"	vec4 c;",
		"	c = texture2DRect(texture, coord+vec2(-2.0, -2.0)); if (c.a != 0.0) { ++n; sum += 0.003663 * c; }",
		"	c = texture2DRect(texture, coord+vec2(-1.0, -2.0)); if (c.a != 0.0) { ++n; sum += 0.014652 * c; }",
		"	c = texture2DRect(texture, coord+vec2( 0.0, -2.0)); if (c.a != 0.0) { ++n; sum += 0.025641 * c; }",
		"	c = texture2DRect(texture, coord+vec2( 1.0, -2.0)); if (c.a != 0.0) { ++n; sum += 0.014652 * c; }",
		"	c = texture2DRect(texture, coord+vec2( 2.0, -2.0)); if (c.a != 0.0) { ++n; sum += 0.003663 * c; }",
		"	c = texture2DRect(texture, coord+vec2(-2.0, -1.0)); if (c.a != 0.0) { ++n; sum += 0.014652 * c; }",
		"	c = texture2DRect(texture, coord+vec2(-1.0, -1.0)); if (c.a != 0.0) { ++n; sum += 0.058608 * c; }",
		"	c = texture2DRect(texture, coord+vec2( 0.0, -1.0)); if (c.a != 0.0) { ++n; sum += 0.095238 * c; }",
		"	c = texture2DRect(texture, coord+vec2( 1.0, -1.0)); if (c.a != 0.0) { ++n; sum += 0.058608 * c; }",
		"	c = texture2DRect(texture, coord+vec2( 2.0, -1.0)); if (c.a != 0.0) { ++n; sum += 0.014652 * c; }",
		"	c = texture2DRect(texture, coord+vec2(-2.0,  0.0)); if (c.a != 0.0) { ++n; sum += 0.025641 * c; }",
		"	c = texture2DRect(texture, coord+vec2(-1.0,  0.0)); if (c.a != 0.0) { ++n; sum += 0.095238 * c; }",
		"	c = texture2DRect(texture, coord+vec2( 1.0,  0.0)); if (c.a != 0.0) { ++n; sum += 0.095238 * c; }",
		"	c = texture2DRect(texture, coord+vec2( 2.0,  0.0)); if (c.a != 0.0) { ++n; sum += 0.025641 * c; }",
		"	c = texture2DRect(texture, coord+vec2(-2.0,  1.0)); if (c.a != 0.0) { ++n; sum += 0.014652 * c; }",
		"	c = texture2DRect(texture, coord+vec2(-1.0,  1.0)); if (c.a != 0.0) { ++n; sum += 0.058608 * c; }",
		"	c = texture2DRect(texture, coord+vec2( 0.0,  1.0)); if (c.a != 0.0) { ++n; sum += 0.095238 * c; }",
		"	c = texture2DRect(texture, coord+vec2( 1.0,  1.0)); if (c.a != 0.0) { ++n; sum += 0.058608 * c; }",
		"	c = texture2DRect(texture, coord+vec2( 2.0,  1.0)); if (c.a != 0.0) { ++n; sum += 0.014652 * c; }",
		"	c = texture2DRect(texture, coord+vec2(-2.0,  2.0)); if (c.a != 0.0) { ++n; sum += 0.003663 * c; }",
		"	c = texture2DRect(texture, coord+vec2(-1.0,  2.0)); if (c.a != 0.0) { ++n; sum += 0.014652 * c; }",
		"	c = texture2DRect(texture, coord+vec2( 0.0,  2.0)); if (c.a != 0.0) { ++n; sum += 0.025641 * c; }",
		"	c = texture2DRect(texture, coord+vec2( 1.0,  2.0)); if (c.a != 0.0) { ++n; sum += 0.014652 * c; }",
		"	c = texture2DRect(texture, coord+vec2( 2.0,  2.0)); if (c.a != 0.0) { ++n; sum += 0.003663 * c; }",
		"	c = texture2DRect(texture, coord                 ); if (c.a != 0.0) { ++n; sum += 0.150183 * c; }",
		"",
		"	gl_FragColor = (n > 0 && n < 25) ? sum : c;",
		"}"
	};

}
