package ch.kuramo.javie.effects.utility;

import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;

import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.plugin.PIAnimatableInteger;
import ch.kuramo.javie.api.plugin.PIVideoBuffer;
import ch.kuramo.javie.api.plugin.PIVideoRenderContext;
import ch.kuramo.javie.effects.VideoEffectUtil;

import com.google.inject.Inject;

@Effect(id="ch.kuramo.javie.ChangeBounds", category=Effect.UTILITY)
public class ChangeBounds {

	private final PIVideoRenderContext context;

	@Property
	private PIAnimatableInteger	left;

	@Property
	private PIAnimatableInteger	top;

	@Property
	private PIAnimatableInteger	right;

	@Property
	private PIAnimatableInteger	bottom;


	@Inject
	public ChangeBounds(PIVideoRenderContext context) {
		this.context = context;
	}

	public VideoBounds getVideoBounds() {
		int left = context.value(this.left);
		int top = context.value(this.top);
		int right = context.value(this.right);
		int bottom = context.value(this.bottom);

		VideoBounds bounds = context.getPreviousBounds();

		return new VideoBounds(
				bounds.x - left,
				bounds.y - top,
				Math.max(0, bounds.width + left + right),
				Math.max(0, bounds.height + top + bottom));
	}

	public PIVideoBuffer doVideoEffect() {
		int left = context.value(this.left);
		int top = context.value(this.top);
		int right = context.value(this.right);
		int bottom = context.value(this.bottom);

		PIVideoBuffer input = context.doPreviousEffect();
		VideoBounds oldBounds = input.getBounds();

		VideoBounds newBounds = new VideoBounds(
				oldBounds.x - left,
				oldBounds.y - top,
				Math.max(0, oldBounds.width + left + right),
				Math.max(0, oldBounds.height + top + bottom));

		if (newBounds.equals(oldBounds)) {
			return input;
		}

		PIVideoBuffer buffer = context.createVideoBuffer(newBounds);
		try {
			GL gl = context.getGL();
			GLU glu = context.getGLU();

			VideoEffectUtil.clearTexture(buffer, gl);

			VideoEffectUtil.ortho2D(gl, glu, newBounds.width, newBounds.height);

			gl.glMatrixMode(GL.GL_MODELVIEW);
			gl.glTranslatef(left, top, 0);

			gl.glFramebufferTexture2DEXT(GL.GL_FRAMEBUFFER_EXT,
					GL.GL_COLOR_ATTACHMENT0_EXT, GL.GL_TEXTURE_RECTANGLE_EXT, buffer.getTexture(), 0);
			gl.glDrawBuffer(GL.GL_COLOR_ATTACHMENT0_EXT);

			gl.glActiveTexture(GL.GL_TEXTURE0);
			gl.glBindTexture(GL.GL_TEXTURE_RECTANGLE_EXT, input.getTexture());
			gl.glEnable(GL.GL_TEXTURE_RECTANGLE_EXT);

			int w = oldBounds.width;
			int h = oldBounds.height;

			gl.glBegin(GL.GL_QUADS);
			gl.glTexCoord2f(0, 0);
			gl.glVertex2f(0, 0);
			gl.glTexCoord2f(w, 0);
			gl.glVertex2f(w, 0);
			gl.glTexCoord2f(w, h);
			gl.glVertex2f(w, h);
			gl.glTexCoord2f(0, h);
			gl.glVertex2f(0, h);
			gl.glEnd();

			gl.glDisable(GL.GL_TEXTURE_RECTANGLE_EXT);
			gl.glBindTexture(GL.GL_TEXTURE_RECTANGLE_EXT, 0);

			gl.glFramebufferTexture2DEXT(GL.GL_FRAMEBUFFER_EXT,
					GL.GL_COLOR_ATTACHMENT0_EXT, GL.GL_TEXTURE_RECTANGLE_EXT, 0, 0);

			PIVideoBuffer output = buffer;
			buffer = null;
			return output;

		} finally {
			input.dispose();
			if (buffer != null) buffer.dispose();
		}
	}

}
