/*
 * Copyright (c) 2009 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.app;

import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;

public class ColorUtil {

	private static final boolean COCOA = SWT.getPlatform().equals("cocoa");


	private static ColorRegistry getRegistry() {
		return Activator.getDefault().getColorRegistry();
	}

	private static Color getSystemColor(int id) {
		return Display.getCurrent().getSystemColor(id);
	}


	public static Color tableBackground() {
		return getRegistry().get(Activator.COLOR_TABLE_BACKGROUND);
	}

	public static Color tableRowLine() {
		if (COCOA) {
			return getRegistry().get(Activator.COLOR_TABLE_ROW_LINE_COCOA);
		} else {
			throw new UnsupportedOperationException("tableRowLine is only for cocoa platform");
		}
	}

	public static Color layerRowBackground() {
		return getRegistry().get(Activator.COLOR_LAYER_ROW_BACKGROUND);
	}

	public static Color switchBorderTopLeft(boolean hilighted, boolean focused, boolean layerSwitch) {
		if (COCOA && hilighted) {
			return getRegistry().get(focused
					? Activator.COLOR_SWITCH_BORDER_COCOA_BLUE_TL
					: Activator.COLOR_SWITCH_BORDER_COCOA_GRAY_TL);

		} else if (layerSwitch) {
			return getSystemColor(SWT.COLOR_DARK_GRAY);

		} else {
			return getRegistry().get(Activator.COLOR_SWITCH_BORDER_LIGHT_GRAY_TL);
		}
	}

	public static Color switchBorderBottomRight(boolean hilighted, boolean focused, boolean layerSwitch) {
		if (COCOA && hilighted) {
			return getRegistry().get(focused
					? Activator.COLOR_SWITCH_BORDER_COCOA_BLUE_BR
					: Activator.COLOR_SWITCH_BORDER_COCOA_GRAY_BR);

		} else if (layerSwitch) {
			return getSystemColor(SWT.COLOR_GRAY);

		} else {
			return getRegistry().get(Activator.COLOR_SWITCH_BORDER_LIGHT_GRAY_BR);
		}
	}


	private ColorUtil() { }

}
