/*
 * Copyright (c) 2009 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.app.views;

import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.List;
import java.util.WeakHashMap;

import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ch.kuramo.javie.app.views.layercomp.Element;
import ch.kuramo.javie.app.views.layercomp.LayerElement;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.Util;

public class LayerCompositionContentProvider implements ITreeContentProvider {

	private static final Logger _logger = LoggerFactory.getLogger(LayerCompositionContentProvider.class);


	private TreeViewer _viewer;

	private LayerComposition _composition;

	private final WeakHashMap<Layer, WeakReference<LayerElement>> _layerElements = Util.newWeakHashMap();


	public void dispose() {
		_viewer = null;
		_composition = null;
		_layerElements.clear();
	}

	public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
		_viewer = (TreeViewer) viewer;
		_composition = (LayerComposition) newInput;
		_layerElements.clear();
	}

	public boolean hasChildren(Object element) {
		return ((Element) element).hasChildren();
	}

	public Object[] getChildren(Object parentElement) {
		return ((Element) parentElement).getChildren();
	}

	public Object[] getElements(Object inputElement) {
		List<LayerElement> layerElements = Util.newList();

		for (Layer layer : _composition.getLayers()) {
			WeakReference<LayerElement> ref = _layerElements.get(layer);
			LayerElement element = (ref != null) ? ref.get() : null;
			if (element == null) {
				element = new LayerElement(_viewer, layer);
				_layerElements.put(layer, new WeakReference<LayerElement>((LayerElement) element));
			}
			layerElements.add(element);
		}

		Collections.reverse(layerElements);

		return layerElements.toArray();
	}

	public Object getParent(Object element) {
		if (element instanceof Element) {
			return ((Element) element).parent;

		} else {
			_logger.debug("getParent: " + element);
			return null;
		}
	}

}
