/*
 * Copyright (c) 2009,2010 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.app.views.layercomp;

import ch.kuramo.javie.app.views.LayerCompositionView;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.TextLayer;

public class TextElement extends Element {

	private Element[] children;


	public TextElement(LayerElement parent) {
		super(parent);
	}

	public String getColumnText(int columnIndex) {
		switch (columnIndex) {
			case LayerCompositionView.NAME_COL:
				return "テキスト";

			default:
				return null;
		}
	}

	@Override
	public boolean hasChildren() {
		return true;
	}

	@Override
	public Element[] getChildren() {
		if (children == null) {
			Layer layer = ((LayerElement) parent).layer;
			children = new Element[] {
					new TextSourceElement(this, (TextLayer) layer),
					new TextFontElement(this, (TextLayer) layer),
					new LayerAnimatableValueElement(this, layer, "fontSize", "フォントサイズ", "px"),
					new LayerAnimatableValueElement(this, layer, "fillColor", "塗りのカラー"),
					new LayerAnimatableValueElement(this, layer, "horizontalAlignment", "整列"),
					new TextLeadingElement(this, (TextLayer) layer)
			};
		}
		return children;
	}

}
