/*
 * Copyright (c) 2009,2010 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.core;

import java.util.Collection;

import org.mozilla.javascript.Context;

import ch.kuramo.javie.api.IAnimatableEnum;
import ch.kuramo.javie.core.exprelems.StringProperty;

public abstract class AbstractAnimatableEnum<E extends Enum<E>>
		extends AbstractAnimatableValue<E> implements AnimatableEnum<E>, IAnimatableEnum<E> {

	private final Class<E> _enumType;

	protected AbstractAnimatableEnum(Class<E> enumType,
			E staticValue, Collection<Keyframe<E>> keyframes, String expression) {

		super(staticValue, keyframes, expression);
		_enumType = enumType;
	}

	protected AbstractAnimatableEnum(Class<E> enumType, E defaultValue) {
		super(defaultValue);
		_enumType = enumType;
	}

	public Class<E> getEnumType() {
		return _enumType;
	}

	public E jsToJava(Object jsValue) {
		return Enum.valueOf(_enumType, (String) Context.jsToJava(jsValue, String.class));
	}

	public StringProperty createExpressionElement(final RenderContext renderContext) {
		return new StringProperty() {
			public String getValue()			{ return value(renderContext).name(); }
			public String valueAtTime(double t)	{ return AbstractAnimatableEnum.this.valueAtTime(t, renderContext).name(); }
		};
	}

}
