/*
 * Copyright (c) 2003 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 
 * - Redistribution of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 * 
 * - Redistribution in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer in the
 *   documentation and/or other materials provided with the distribution.
 * 
 * Neither the name of Sun Microsystems, Inc. or the names of
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * 
 * This software is provided "AS IS," without a warranty of any kind. ALL
 * EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES,
 * INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE HEREBY EXCLUDED. SUN
 * MICROSYSTEMS, INC. ("SUN") AND ITS LICENSORS SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN OR
 * ITS LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR
 * DIRECT, INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE
 * DAMAGES, HOWEVER CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY,
 * ARISING OUT OF THE USE OF OR INABILITY TO USE THIS SOFTWARE, EVEN IF
 * SUN HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 * 
 * You acknowledge that this software is not designed or intended for use
 * in the design, construction, operation or maintenance of any nuclear
 * facility.
 * 
 * Sun gratefully acknowledges that this software was originally authored
 * and developed by Kenneth Bradley Russell and Christopher John Kline.
 */

/*
 * Yoshikazu Kuramochi derived this file from MacOSXCGLContext.java in JOGL-2.0.
 */

package ch.kuramo.javie.core.internal;

import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLContext;

import com.sun.opengl.impl.macosx.cgl.CGL;
import com.sun.opengl.impl.macosx.cgl.MacOSXCGLDrawable;
import com.sun.opengl.impl.macosx.cgl.MacOSXPbufferCGLContext;

public class MacOSXOpenGLPixelFormat {

	public static long createPixelFormat(GLContext context) {
		GLCapabilities capabilities = ((MacOSXCGLDrawable) context.getGLDrawable()).getChosenGLCapabilities();
		int[] iattribs = new int[128];
		int[] ivalues = new int[128];
		int idx = 0;
		if (context instanceof MacOSXPbufferCGLContext) {
			iattribs[idx] = CGL.NSOpenGLPFAPixelBuffer;		ivalues[idx] = 1;	idx++;
		}
		if (capabilities.getPbufferFloatingPointBuffers()) {
			iattribs[idx] = CGL.kCGLPFAColorFloat;			ivalues[idx] = 1;	idx++;
		}
		iattribs[idx] = CGL.NSOpenGLPFADoubleBuffer;		ivalues[idx] = (capabilities.getDoubleBuffered() ? 1 : 0);	idx++;
		iattribs[idx] = CGL.NSOpenGLPFAStereo;				ivalues[idx] = (capabilities.getStereo() ? 1 : 0);			idx++;
		iattribs[idx] = CGL.NSOpenGLPFAColorSize;			ivalues[idx] = (capabilities.getRedBits() +
																			capabilities.getGreenBits() +
																			capabilities.getBlueBits());		idx++;
		iattribs[idx] = CGL.NSOpenGLPFAAlphaSize;			ivalues[idx] = capabilities.getAlphaBits();			idx++;
		iattribs[idx] = CGL.NSOpenGLPFADepthSize;			ivalues[idx] = capabilities.getDepthBits();			idx++;
		iattribs[idx] = CGL.NSOpenGLPFAAccumSize;			ivalues[idx] = (capabilities.getAccumRedBits() +
																			capabilities.getAccumGreenBits() +
																			capabilities.getAccumBlueBits() +
																			capabilities.getAccumAlphaBits());	idx++;
		iattribs[idx] = CGL.NSOpenGLPFAStencilSize;			ivalues[idx] = capabilities.getStencilBits();		idx++;
		if (capabilities.getSampleBuffers()) {
			iattribs[idx] = CGL.NSOpenGLPFASampleBuffers;	ivalues[idx] = 1;								idx++;
			iattribs[idx] = CGL.NSOpenGLPFASamples;			ivalues[idx] = capabilities.getNumSamples();	idx++;
		}
		
		return CGL.createPixelFormat(iattribs, 0, idx, ivalues, 0);
	}

	public static void deletePixelFormat(long pixelFormat) {
		CGL.deletePixelFormat(pixelFormat);
	}


	private MacOSXOpenGLPixelFormat() { }

}
