/*
 * Copyright (c) 2009 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.core.internal;

import java.io.File;

import net.arnx.jsonic.JSONHint;
import ch.kuramo.javie.core.AbstractItem;
import ch.kuramo.javie.core.FileItem;
import ch.kuramo.javie.core.MediaFileInput;
import ch.kuramo.javie.core.MediaItem;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.ProjectDecodeException;
import ch.kuramo.javie.core.annotations.ProjectElement;
import ch.kuramo.javie.core.services.MediaFileInputFactory;

import com.google.inject.Inject;

@ProjectElement("mediaFile")
public class MediaFileItem extends AbstractItem implements MediaItem, FileItem {

	private File _file;

	private MediaFileInput _mediaFileInput;

	@Inject
	private MediaFileInputFactory _mediaFileInputFactory;


	public MediaFileItem() {
		super();
	}

	public void initialize(File file) {
		super.initialize();
		_file = file;
		setName(_file.getName());
		_mediaFileInput = _mediaFileInputFactory.get(getId(), _file);
	}

	@Override
	protected void finalize() throws Throwable {
		dispose();
		super.finalize();
	}

	public void dispose() {
		if (_mediaFileInput != null) {
			_mediaFileInputFactory.release(getId());
			_mediaFileInput = null;
		}
	}

	public File getFile() {
		return _file;
	}

	public void setFile(File file) {
		_file = file;
	}

	@JSONHint(ignore=true)
	public MediaFileInput getMediaInput() {
		return _mediaFileInput;
	}

	@Override
	public void afterDecode(Project p) throws ProjectDecodeException {
		super.afterDecode(p);
		_mediaFileInput = _mediaFileInputFactory.get(getId(), _file);
	}

	@JSONHint(ignore=true)
	public String getKind() {
		// TODO
		return null;
	}

}
