/*
 * Copyright (c) 2010 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#import <Cocoa/Cocoa.h>
#import <QuickTime/QuickTime.h>
#import <jni.h>


@interface QTMovieOutput : NSObject {
	
	MovieExportComponent mExporter;
	MovieExportGetPropertyUPP mVideoPropUPP;
	MovieExportGetDataUPP mVideoDataUPP;
	ImageDescriptionHandle mImageDesc;
	MovieExportGetPropertyUPP mAudioPropUPP;
	MovieExportGetDataUPP mAudioDataUPP;
	SoundDescriptionHandle mSoundDesc;
	
	TimeScale mVideoTimeScale;
	TimeValue64 mVideoFrameDuration;
	TimeValue64 mVideoDuration;
	long mAudioChannels;
	long mAudioSampleRate;
	long mAudioSampleSize;
	TimeValue64 mAudioDuration;
	
	JNIEnv* mJNIEnv;
	jobject mJavaObj;
	
	char* mVideoBuffer;
	jobject mVideoBufferDirect;
	jmethodID mVideoRequestMethod;
	char* mAudioBuffer;
	jobject mAudioBufferDirect;
	jmethodID mAudioRequestMethod;
	
	jmethodID mProgressMethod;
	
}

-(jint) openMovieExportComponent;

-(jint) doUserDialog;

-(jint) getSettings:(JNIEnv*)jniEnv
				   :(jbyteArray*)settings;

-(jint) setSettings:(JNIEnv*)jniEnv
				   :(jbyteArray)settings;

-(jint) addVideoSource:(long)vWidth
					  :(long)vHeight
					  :(TimeScale)vTimeScale
					  :(TimeValue64)vFrameDuration
					  :(TimeValue64)vDuration;

-(jint) addAudioSource:(long)aChannels
					  :(long)aSampleRate
					  :(long)aSampleSize
					  :(Boolean)aFloat
					  :(TimeValue64)aDuration;

-(jint) doOutput:(JNIEnv*)jniEnv
				:(jobject)javaObj
				:(CFStringRef)filename;

@end
