/*
 * Copyright (c) 2010 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#import "QTMovieOutputJNI.h"
#import "QTMovieOutput.h"


JNIEXPORT jint JNICALL JNI_OnLoad(JavaVM* vm, void* reserved)
{
	return JNI_VERSION_1_4;
}

NSString* jstringToNSString(JNIEnv* env, jstring jstr)
{
	const jchar* chars = (*env)->GetStringChars(env, jstr, NULL);
	NSString* nsstr = [NSString stringWithCharacters:(UniChar*)chars
											  length:(*env)->GetStringLength(env, jstr)];
	(*env)->ReleaseStringChars(env, jstr, chars);
	return nsstr;
}

JNIEXPORT jint JNICALL Java_ch_kuramo_javie_core_output_MacOSXQTMovieOutput_doUserDialogAndGetSettings
(JNIEnv* env, jclass class, jobjectArray ioSettings)
{
	NSAutoreleasePool* pool = [[NSAutoreleasePool alloc] init];
	jint error = noErr;
	
	QTMovieOutput* qtOut = [[[QTMovieOutput alloc] init] autorelease];
	error = [qtOut openMovieExportComponent];
	if (error != noErr) goto bail;
	
	jbyteArray settings = (*env)->GetObjectArrayElement(env, ioSettings, 0);
	if (settings != NULL) {
		error = [qtOut setSettings:env:settings];
		if (error != noErr) goto bail;
	}
	
	error = [qtOut doUserDialog];
	if (error != noErr) goto bail;
	
	error = [qtOut getSettings:env:&settings];
	if (error != noErr) goto bail;
	
	(*env)->SetObjectArrayElement(env, ioSettings, 0, settings);
	
bail:
	[pool release];
	return error;
}

JNIEXPORT jint JNICALL Java_ch_kuramo_javie_core_output_MacOSXQTMovieOutput_doOutput
(JNIEnv* env, jobject javaObj,
 jbyteArray settings, jstring filename,
 jint vWidth, jint vHeight, jint vTimeScale, jlong vFrameDuration, jlong vDuration,
 jint aChannels, jint aSampleRate, jint aSampleSize, jboolean aFloat, jlong aDuration)
{
	if (vDuration <= 0 && aDuration <= 0) return paramErr;
	
	NSAutoreleasePool* pool = [[NSAutoreleasePool alloc] init];
	jint error = noErr;
	
	QTMovieOutput* qtOut = [[[QTMovieOutput alloc] init] autorelease];
	error = [qtOut openMovieExportComponent];
	if (error != noErr) goto bail;
	
	if (settings != NULL) {
		error = [qtOut setSettings:env:settings];
		if (error != noErr) goto bail;
	}
	
	if (vDuration > 0) {
		error = [qtOut addVideoSource:vWidth:vHeight:vTimeScale:vFrameDuration:vDuration];
		if (error != noErr) goto bail;
	}
	
	if (aDuration > 0) {
		error = [qtOut addAudioSource:aChannels:aSampleRate:aSampleSize:aFloat:aDuration];
		if (error != noErr) goto bail;
	}
	
	error = [qtOut doOutput:env:javaObj:(CFStringRef)jstringToNSString(env, filename)];
	if (error != noErr) goto bail;
	
bail:
	[pool release];
	return error;
}
