package ftgl;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.ptr.DoubleByReference;

public class FTGL {

	public static final String LIBNAME = "ftgl";

	private static final FTGLLib lib = (FTGLLib) Native.loadLibrary(LIBNAME, FTGLLib.class);


	////////////////////////////////////////////////////////////////////////////////
	// ftgl                                                                       //
	////////////////////////////////////////////////////////////////////////////////

	public static final int FTGL_RENDER_FRONT = 0x0001;
	public static final int FTGL_RENDER_BACK  = 0x0002;
	public static final int FTGL_RENDER_SIDE  = 0x0004;
	public static final int FTGL_RENDER_ALL   = 0xffff;

	public static final int FTGL_ALIGN_LEFT    = 0;
	public static final int FTGL_ALIGN_CENTER  = 1;
	public static final int FTGL_ALIGN_RIGHT   = 2;
	public static final int FTGL_ALIGN_JUSTIFY = 3;


	public synchronized static int ftglAttachFile(FTGLfont font, String path) {
		return lib.ftglAttachFile(font, path);
	}

	public synchronized static FTGLfont ftglCreateBitmapFont(String file) {
		return lib.ftglCreateBitmapFont(file);
	}

	public synchronized static FTGLfont ftglCreateBufferFont(String file) {
		return lib.ftglCreateBufferFont(file);
	}

	public synchronized static FTGLfont ftglCreateExtrudeFont(String file) {
		return lib.ftglCreateExtrudeFont(file);
	}

	public synchronized static FTGLfont ftglCreateOutlineFont(String file) {
		return lib.ftglCreateOutlineFont(file);
	}

	public synchronized static FTGLfont ftglCreatePixmapFont(String file) {
		return lib.ftglCreatePixmapFont(file);
	}

	public synchronized static FTGLfont ftglCreatePolygonFont(String file) {
		return lib.ftglCreatePolygonFont(file);
	}

	public synchronized static FTGLlayout ftglCreateSimpleLayout() {
		return lib.ftglCreateSimpleLayout();
	}

	public synchronized static FTGLfont ftglCreateTextureFont(String file) {
		return lib.ftglCreateTextureFont(file);
	}

	public synchronized static void ftglDestroyFont(FTGLfont font) {
		lib.ftglDestroyFont(font);
	}

	public synchronized static void ftglDestroyGlyph(FTGLglyph glyph) {
		lib.ftglDestroyGlyph(glyph);
	}

	public synchronized static void ftglDestroyLayout(FTGLlayout layout) {
		lib.ftglDestroyLayout(layout);
	}

	public synchronized static float ftglGetFontAdvance(FTGLfont font, String string) {
		return lib.ftglGetFontAdvance(font, string);
	}

	public synchronized static float ftglGetFontAscender(FTGLfont font) {
		return lib.ftglGetFontAscender(font);
	}

	public synchronized static void ftglGetFontBBox(FTGLfont font, String string, int len, float[] bounds) {
		lib.ftglGetFontBBox(font, string, len, bounds);
	}

	public synchronized static int ftglGetFontCharMapCount(FTGLfont font) {
		return lib.ftglGetFontCharMapCount(font);
	}

	public synchronized static int ftglGetFontCharMapList(FTGLfont font) {
		return lib.ftglGetFontCharMapList(font);
	}

	public synchronized static float ftglGetFontDescender(FTGLfont font) {
		return lib.ftglGetFontDescender(font);
	}

	public synchronized static int ftglGetFontError(FTGLfont font) {
		return lib.ftglGetFontError(font);
	}

	public synchronized static int ftglGetFontFaceSize(FTGLfont font) {
		return lib.ftglGetFontFaceSize(font);
	}

	public synchronized static float ftglGetFontLineHeight(FTGLfont font) {
		return lib.ftglGetFontLineHeight(font);
	}

	public synchronized static float ftglGetGlyphAdvance(FTGLglyph glyph) {
		return lib.ftglGetGlyphAdvance(glyph);
	}

	public synchronized static void ftglGetGlyphBBox(FTGLglyph glyph, float[] bounds) {
		lib.ftglGetGlyphBBox(glyph, bounds);
	}

	public synchronized static int ftglGetGlyphError(FTGLglyph glyph) {
		return lib.ftglGetGlyphError(glyph);
	}

	public synchronized static int ftglGetLayoutAlignement(FTGLlayout layout) {
		return lib.ftglGetLayoutAlignement(layout);
	}

	public synchronized static void ftglGetLayoutBBox(FTGLlayout layout, String string, float[] bounds) {
		lib.ftglGetLayoutBBox(layout, string, bounds);
	}

	public synchronized static int ftglGetLayoutError(FTGLlayout layout) {
		return lib.ftglGetLayoutError(layout);
	}

	public synchronized static FTGLfont ftglGetLayoutFont(FTGLlayout layout) {
		return lib.ftglGetLayoutFont(layout);
	}

	public synchronized static float ftglGetLayoutLineLength(FTGLlayout layout) {
		return lib.ftglGetLayoutLineLength(layout);
	}

	public synchronized static float ftglGetLayoutLineSpacing(FTGLlayout layout) {
		return lib.ftglGetLayoutLineSpacing(layout);
	}

	public synchronized static void ftglRenderFont(FTGLfont font, String string, int mode) {
		lib.ftglRenderFont(font, string, mode);
	}

	public synchronized static void ftglRenderGlyph(
			FTGLglyph glyph, double penx, double peny,
			int renderMode, double[] advancex, double[] advancey) {
		lib.ftglRenderGlyph(glyph, penx, peny, renderMode, advancex, advancey);
	}

	public synchronized static void ftglRenderGlyph(
			FTGLglyph glyph, double penx, double peny,
			int renderMode, DoubleByReference advancex, DoubleByReference advancey) {
		lib.ftglRenderGlyph(glyph, penx, peny, renderMode, advancex, advancey);
	}

	public synchronized static void ftglRenderLayout(FTGLlayout layout, String string, int mode) {
		lib.ftglRenderLayout(layout, string, mode);
	}

	public synchronized static int ftglSetFontCharMap(FTGLfont font, int encoding) {
		return lib.ftglSetFontCharMap(font, encoding);
	}

	public synchronized static void ftglSetFontDepth(FTGLfont font, float depth) {
		lib.ftglSetFontDepth(font, depth);
	}

	public synchronized static void ftglSetFontDisplayList(FTGLfont font, int useList) {
		lib.ftglSetFontDisplayList(font, useList);
	}

	public synchronized static int ftglSetFontFaceSize(FTGLfont font, int size, int res) {
		return lib.ftglSetFontFaceSize(font, size, res);
	}

	public synchronized static void ftglSetFontOutset(FTGLfont font, float front, float back) {
		lib.ftglSetFontOutset(font, front, back);
	}

	public synchronized static void ftglSetLayoutAlignment(FTGLlayout layout, int alignment) {
		lib.ftglSetLayoutAlignment(layout, alignment);
	}

	public synchronized static void ftglSetLayoutFont(FTGLlayout layout, FTGLfont fontInit) {
		lib.ftglSetLayoutFont(layout, fontInit);
	}

	public synchronized static void ftglSetLayoutLineLength(FTGLlayout layout, float lineLength) {
		lib.ftglSetLayoutLineLength(layout, lineLength);
	}

	public synchronized static void ftglSetLayoutLineSpacing(FTGLlayout layout, float lineSpacing) {
		lib.ftglSetLayoutLineSpacing(layout, lineSpacing);
	}


	////////////////////////////////////////////////////////////////////////////////
	// freetype                                                                   //
	////////////////////////////////////////////////////////////////////////////////

	public static final int FT_ENCODING_UNICODE		= 1970170211;	// 'unic'

	public static final int FT_Err_Ok				= 0x00;
	public static final int FT_Err_Invalid_Argument	= 0x06;


	public static int ft_Done_Face(FT_Face face) {
		return lib.ft_Done_Face(face);
	}

	public static int ft_Done_FreeType(FT_Library library) {
		return lib.ft_Done_FreeType(library);
	}

	public static int ft_Get_Sfnt_Name_Count(FT_Face face) {
		return lib.ft_Get_Sfnt_Name_Count(face);
	}

	public static int ft_Get_Sfnt_Name(FT_Face face, int idx, FT_SfntName[] sfntName) {
		return lib.ft_Get_Sfnt_Name(face, idx, sfntName);
	}

	public static int ft_Init_FreeType(FT_Library[] alibrary) {
		return lib.ft_Init_FreeType(alibrary);
	}

	public static int ft_New_Face(FT_Library library, String filename, int faceIndex, FT_Face[] aface) {
		return lib.ft_New_Face(library, filename, faceIndex, aface);
	}

}

interface FTGLLib extends Library {

	////////////////////////////////////////////////////////////////////////////////
	// FTGlyph.h                                                                  //
	////////////////////////////////////////////////////////////////////////////////


//	/**
//	 * Create a custom FTGL glyph object.
//	 * 
//	 * FTGLglyph *ftglCreateCustomGlyph(FTGLglyph *base, void *data,
//	 *                  void(*renderCallback)(FTGLglyph *, void *, FTGL_DOUBLE, FTGL_DOUBLE, int, FTGL_DOUBLE *, FTGL_DOUBLE *),
//	 *                  void(*destroyCallback)(FTGLglyph *, void *))
//	 */


	/**
	 * Destroy an FTGL glyph object.
	 * 
	 * void ftglDestroyGlyph(FTGLglyph *glyph)
	 */
	void ftglDestroyGlyph(FTGLglyph glyph);


	/**
	 * Render a glyph at the current pen position and compute the corresponding advance.
	 * 
	 * void ftglRenderGlyph(FTGLglyph *glyph, FTGL_DOUBLE penx, FTGL_DOUBLE peny,
	 *              int renderMode, FTGL_DOUBLE *advancex, FTGL_DOUBLE *advancey)
	 */
	void ftglRenderGlyph(FTGLglyph glyph, double penx, double peny,
					int renderMode, double[] advancex, double[] advancey);

	void ftglRenderGlyph(FTGLglyph glyph, double penx, double peny,
					int renderMode, DoubleByReference advancex, DoubleByReference advancey);


	/**
	 * Return the advance for a glyph.
	 * 
	 * float ftglGetGlyphAdvance(FTGLglyph *glyph)
	 */
	float ftglGetGlyphAdvance(FTGLglyph glyph);


	/**
	 * Return the bounding box for a glyph.
	 * 
	 * void ftglGetGlyphBBox(FTGLglyph *glyph, float bounds[6])
	 */
	void ftglGetGlyphBBox(FTGLglyph glyph, float[] bounds);


	/**
	 * Query a glyph for errors.
	 * 
	 * FT_Error ftglGetGlyphError(FTGLglyph *glyph)
	 */
	int ftglGetGlyphError(FTGLglyph glyph);



	////////////////////////////////////////////////////////////////////////////////
	// FTBitmapGlyph.h                                                            //
	// FTExtrdGlyph.h                                                             //
	// FTOutlineGlyph.h                                                           //
	// FTPixmapGlyph.h                                                            //
	// FTPolyGlyph.h                                                              //
	// FTTextureGlyph.h                                                           //
	////////////////////////////////////////////////////////////////////////////////


//	/**
//	 * FTGLglyph *ftglCreateBitmapGlyph(FT_GlyphSlot glyph)
//	 */
//
//
//	/**
//	 * FTGLglyph *ftglCreateExtrudeGlyph(FT_GlyphSlot glyph, float depth,
//	 *                  float frontOutset, float backOutset, int useDisplayList)
//	 */
//
//
//	/**
//	 * FTGLglyph *ftglCreateOutlineGlyph(FT_GlyphSlot glyph, float outset, int useDisplayList)
//	 */
//
//
//	/**
//	 * FTGLglyph *ftglCreatePixmapGlyph(FT_GlyphSlot glyph)
//	 */
//	
//
//	/**
//	 * FTGLglyph *ftglCreatePolygonGlyph(FT_GlyphSlot glyph, float outset, int useDisplayList)
//	 */
//
//
//	/**
//	 * FTGLglyph *ftglCreateTextureGlyph(FT_GlyphSlot glyph, int id,
//	 *                  int xOffset, int yOffset, int width, int height)
//	 */



	////////////////////////////////////////////////////////////////////////////////
	// FTFont.h                                                                   //
	////////////////////////////////////////////////////////////////////////////////


//	/**
//	 * Create a custom FTGL font object.
//	 * 
//	 * FTGLfont *ftglCreateCustomFont(char const *fontFilePath, void *data,
//	 *                  FTGLglyph *(*makeglyphCallback)(FT_GlyphSlot, void *))
//	 */


	/**
	 * Destroy an FTGL font object.
	 * 
	 * void ftglDestroyFont(FTGLfont *font)
	 */
	void ftglDestroyFont(FTGLfont font);


	/**
	 * Attach auxilliary file to font e.g.
	 * 
	 * int ftglAttachFile(FTGLfont *font, const char *path)
	 */
	int ftglAttachFile(FTGLfont font, String path);


//	/**
//	 * Attach auxilliary data to font, e.g.
//	 * 
//	 * int ftglAttachData(FTGLfont *font, const unsigned char *data, size_t size)
//	 */


	/**
	 * Set the character map for the face.
	 * 
	 * int ftglSetFontCharMap(FTGLfont *font, FT_Encoding encoding)
	 */
	int ftglSetFontCharMap(FTGLfont font, int encoding);


	/**
	 * Get the number of character maps in this face.
	 * 
	 * unsigned int ftglGetFontCharMapCount(FTGLfont *font)
	 */
	int ftglGetFontCharMapCount(FTGLfont font);


	/**
	 * Get a list of character maps in this face.
	 * 
	 * FT_Encoding *ftglGetFontCharMapList(FTGLfont *font)
	 */
	int ftglGetFontCharMapList(FTGLfont font);


	/**
	 * Set the char size for the current face.
	 * 
	 * int ftglSetFontFaceSize(FTGLfont *font, unsigned int size, unsigned int res)
	 */
	int ftglSetFontFaceSize(FTGLfont font, int size, int res);


	/**
	 * Get the current face size in points (1/72 inch).
	 * 
	 * unsigned int ftglGetFontFaceSize(FTGLfont *font)
	 */
	int ftglGetFontFaceSize(FTGLfont font);


	/**
	 * Set the extrusion distance for the font.
	 * 
	 * void ftglSetFontDepth(FTGLfont *font, float depth)
	 */
	void ftglSetFontDepth(FTGLfont font, float depth);


	/**
	 * Set the outset distance for the font.
	 * 
	 * void ftglSetFontOutset(FTGLfont *font, float front, float back)
	 */
	void ftglSetFontOutset(FTGLfont font, float front, float back);


	/**
	 * Enable or disable the use of Display Lists inside FTGL.
	 * 
	 * void ftglSetFontDisplayList(FTGLfont *font, int useList)
	 */
	void ftglSetFontDisplayList(FTGLfont font, int useList);


	/**
	 * Get the global ascender height for the face.
	 * 
	 * float ftglGetFontAscender(FTGLfont *font)
	 */
	float ftglGetFontAscender(FTGLfont font);


	/**
	 * Gets the global descender height for the face.
	 * 
	 * float ftglGetFontDescender(FTGLfont *font)
	 */
	float ftglGetFontDescender(FTGLfont font);


	/**
	 * Gets the line spacing for the font.
	 * 
	 * float ftglGetFontLineHeight(FTGLfont *font)
	 */
	float ftglGetFontLineHeight(FTGLfont font);


	/**
	 * Get the bounding box for a string.
	 * 
	 * void ftglGetFontBBox(FTGLfont *font, const char *string, int len, float bounds[6])
	 */
	void ftglGetFontBBox(FTGLfont font, String string, int len, float bounds[]);


	/**
	 * Get the advance width for a string
	 * 
	 * float ftglGetFontAdvance(FTGLfont *font, const char *string)
	 */
	float ftglGetFontAdvance(FTGLfont font, String string);


	/**
	 * Render a string of characters.
	 * 
	 * void ftglRenderFont(FTGLfont *font, const char *string, int mode)
	 */
	void ftglRenderFont(FTGLfont font, String string, int mode);


	/**
	 * Query a font for errors.
	 * 
	 * FT_Error ftglGetFontError(FTGLfont *font)
	 */
	int ftglGetFontError(FTGLfont font);



	////////////////////////////////////////////////////////////////////////////////
	// FTGLBitmapFont.h                                                           //
	// FTBufferFont.h                                                             //
	// FTGLExtrdFont.h                                                            //
	// FTGLOutlineFont.h                                                          //
	// FTGLPixmapFont.h                                                           //
	// FTGLPolygonFont.h                                                          //
	// FTGLTextureFont.h                                                          //
	////////////////////////////////////////////////////////////////////////////////


	/**
	 * Open and read a font file. 
	 * 
	 * FTGLfont *ftglCreateBitmapFont(const char *file)
	 */
	FTGLfont ftglCreateBitmapFont(String file);


	/**
	 * Open and read a font file.
	 * 
	 * FTGLfont *ftglCreateBufferFont(const char *file)
	 */
	FTGLfont ftglCreateBufferFont(String file);


	/**
	 * Open and read a font file.
	 * 
	 * FTGLfont *ftglCreateExtrudeFont(const char *file)
	 */
	FTGLfont ftglCreateExtrudeFont(String file);


	/**
	 * Open and read a font file.
	 * 
	 * FTGLfont *ftglCreateOutlineFont(const char *file)
	 */
	FTGLfont ftglCreateOutlineFont(String file);


	/**
	 * Open and read a font file.
	 * 
	 * FTGLfont *ftglCreatePixmapFont(const char *file)
	 */
	FTGLfont ftglCreatePixmapFont(String file);


	/**
	 * Open and read a font file.
	 * 
	 * FTGLfont *ftglCreatePolygonFont(const char *file)
	 */
	FTGLfont ftglCreatePolygonFont(String file);


	/**
	 * Open and read a font file.
	 * 
	 * FTGLfont *ftglCreateTextureFont(const char *file)
	 */
	FTGLfont ftglCreateTextureFont(String file);



	////////////////////////////////////////////////////////////////////////////////
	// FTLayout.h                                                                 //
	////////////////////////////////////////////////////////////////////////////////


	/**
	 * Destroy an FTGL layout object.
	 * 
	 * void ftglDestroyLayout(FTGLlayout *layout)
	 */
	void ftglDestroyLayout(FTGLlayout layout);


	/**
	 * Get the bounding box for a string.
	 * 
	 * void ftglGetLayoutBBox(FTGLlayout *layout, const char *string, float bounds[6])
	 */
	void ftglGetLayoutBBox(FTGLlayout layout, String string, float[] bounds);


	/**
	 * Render a string of characters.
	 * 
	 * void ftglRenderLayout(FTGLlayout *layout, const char *string, int mode)
	 */
	void ftglRenderLayout(FTGLlayout layout, String string, int mode);


	/**
	 * Query a layout for errors.
	 * 
	 * FT_Error ftglGetLayoutError (FTGLlayout *layout)
	 */
	int ftglGetLayoutError (FTGLlayout layout);



	////////////////////////////////////////////////////////////////////////////////
	// FTSimpleLayout.h                                                           //
	////////////////////////////////////////////////////////////////////////////////


	/**
	 * FTGLlayout *ftglCreateSimpleLayout(void)
	 */
	FTGLlayout ftglCreateSimpleLayout();


	/**
	 * void ftglSetLayoutFont(FTGLlayout *, FTGLfont*)
	 */
	void ftglSetLayoutFont(FTGLlayout layout, FTGLfont fontInit);


	/**
	 * FTGLfont *ftglGetLayoutFont(FTGLlayout *)
	 */
	FTGLfont ftglGetLayoutFont(FTGLlayout layout);


	/**
	 * void ftglSetLayoutLineLength(FTGLlayout *, const float)
	 */
	void ftglSetLayoutLineLength(FTGLlayout layout, float lineLength);


	/**
	 * float ftglGetLayoutLineLength(FTGLlayout *)
	 */
	float ftglGetLayoutLineLength(FTGLlayout layout);


	/**
	 * void ftglSetLayoutAlignment(FTGLlayout *, const int)
	 */
	void ftglSetLayoutAlignment(FTGLlayout layout, int alignment);


	/**
	 * int ftglGetLayoutAlignement(FTGLlayout *)
	 */
	int ftglGetLayoutAlignement(FTGLlayout layout);


	/**
	 * void ftglSetLayoutLineSpacing(FTGLlayout *, const float)
	 */
	void ftglSetLayoutLineSpacing(FTGLlayout layout, float lineSpacing);


	/**
	 * float ftglGetLayoutLineSpacing(FTGLlayout *)
	 */
	float ftglGetLayoutLineSpacing(FTGLlayout layout);



	////////////////////////////////////////////////////////////////////////////////
	// freetype function wrappers                                                 //
	////////////////////////////////////////////////////////////////////////////////

	int ft_Init_FreeType(FT_Library[] alibrary);
	int ft_Done_FreeType(FT_Library library);
	int ft_New_Face(FT_Library library, String filename, int face_index, FT_Face[] aface);
	int ft_Done_Face(FT_Face face);
	int ft_Get_Sfnt_Name_Count(FT_Face face);
	int ft_Get_Sfnt_Name(FT_Face face, int idx, FT_SfntName[] sfntName);

}
