/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.actions;

import ch.kuramo.javie.app.widgets.GridBuilder;
import ch.kuramo.javie.core.Composition;
import ch.kuramo.javie.core.JavieRuntimeException;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.output.WindowsDirectShowOutput;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

class AVIVideoCompressorWizardPage
extends WizardPage {
    private final Composition _composition;
    private final List<WindowsDirectShowOutput.VideoCompressorDescriptor> _compressors;
    private final Map<Integer, WindowsDirectShowOutput.VideoCompressorSettings> _settingsCache = Util.newMap();
    private int _selectedIndex;
    private Combo _compressorCombo;
    private Text _qualityText;
    private Text _keyFrameText;
    private Text _PFramesText;
    private Text _bitRateText;
    private Text _windowSizeText;
    private Button _configButton;
    private Button _resetButton;
    private Button _aboutButton;
    private boolean _updatingControls;

    AVIVideoCompressorWizardPage(Composition composition, WindowsDirectShowOutput.VideoCompressorSettings defaultVCSettings) {
        super("AVIVideoCompressorWizardPage", "\u30d3\u30c7\u30aa\u306e\u5727\u7e2e", null);
        this.setDescription("\u5727\u7e2e\u30d7\u30ed\u30b0\u30e9\u30e0\u306e\u9078\u629e\u3068\u8a2d\u5b9a\u3092\u3057\u307e\u3059\u3002");
        this._composition = composition;
        this._compressors = WindowsDirectShowOutput.listVideoCompressors((Composition)this._composition);
        Collections.sort(this._compressors, new Comparator<WindowsDirectShowOutput.VideoCompressorDescriptor>(){

            @Override
            public int compare(WindowsDirectShowOutput.VideoCompressorDescriptor o1, WindowsDirectShowOutput.VideoCompressorDescriptor o2) {
                return o1.friendlyName.compareTo(o2.friendlyName);
            }
        });
        this._compressors.add(new WindowsDirectShowOutput.VideoCompressorDescriptor(null, "\u975e\u5727\u7e2e", 0, false, false, -1.0, -1, -1, 0L));
        this._selectedIndex = this._compressors.size() - 1;
        if (defaultVCSettings != null) {
            int i = 0;
            int n = this._compressors.size() - 1;
            while (i < n) {
                WindowsDirectShowOutput.VideoCompressorDescriptor desc = this._compressors.get(i);
                if (desc.moniker.equals(defaultVCSettings.moniker)) {
                    this._settingsCache.put(i, defaultVCSettings.clone());
                    this._selectedIndex = i;
                    break;
                }
                ++i;
            }
        }
    }

    WindowsDirectShowOutput.VideoCompressorSettings getVideoCompressorSettings() {
        return this._settingsCache.get(this._selectedIndex);
    }

    public void createControl(Composite parent) {
        List compressorNames = Util.newList();
        for (WindowsDirectShowOutput.VideoCompressorDescriptor desc : this._compressors) {
            compressorNames.add(desc.friendlyName);
        }
        GridBuilder gb = new GridBuilder(parent, 10, true);
        gb.hSpan(2).hAlign(131072).hGrab().label(0, "\u5727\u7e2e\u30d7\u30ed\u30b0\u30e9\u30e0:");
        this._compressorCombo = gb.hSpan(8).hAlign(4).hGrab().combo(8, compressorNames.toArray(new String[compressorNames.size()]));
        gb.hSpan(10).size(10, 10).composite(0);
        gb.hSpan(3).hAlign(131072).hGrab().label(0, "\u5727\u7e2e\u306e\u54c1\u8cea (0\uff5e100):");
        this._qualityText = gb.hSpan(2).hAlign(4).hGrab().tabAfter((Control)this._compressorCombo).text(2048, "");
        gb.hSpan(2).size(10, 10).composite(0);
        this._configButton = gb.hSpan(3).hAlign(4).hGrab().button(8, "\u8a2d\u5b9a");
        gb.hSpan(3).hAlign(131072).hGrab().label(0, "\u30ad\u30fc\u30d5\u30ec\u30fc\u30e0 (0:\u7121\u3057):");
        this._keyFrameText = gb.hSpan(2).hAlign(4).hGrab().tabAfter((Control)this._qualityText).text(2048, "");
        gb.hSpan(2).hAlign(4).hGrab().label(0, "\u30d5\u30ec\u30fc\u30e0\u3054\u3068");
        this._resetButton = gb.hSpan(3).hAlign(4).hGrab().button(8, "\u6a19\u6e96\u306b\u623b\u3059");
        gb.hSpan(3).hAlign(131072).hGrab().label(0, "\uff77\uff70\uff8c\uff9a\uff70\uff91\u6bce\u306eP\uff8c\uff9a\uff70\uff91:");
        this._PFramesText = gb.hSpan(2).hAlign(4).hGrab().tabAfter((Control)this._keyFrameText).text(2048, "");
        gb.hSpan(2).hAlign(4).hGrab().label(0, "\u30d5\u30ec\u30fc\u30e0");
        this._aboutButton = gb.hSpan(3).hAlign(4).hGrab().button(8, "\u30d0\u30fc\u30b8\u30e7\u30f3\u60c5\u5831");
        gb.hSpan(3).hAlign(131072).hGrab().label(0, "\u30c7\u30fc\u30bf\u30ec\u30fc\u30c8 (0:\u7121\u3057):");
        this._bitRateText = gb.hSpan(2).hAlign(4).hGrab().tabAfter((Control)this._PFramesText).text(2048, "");
        gb.hSpan(2).hAlign(4).hGrab().label(0, "KB/\u79d2");
        gb.hSpan(3).hAlign(4).hGrab().button(8, "").setVisible(false);
        gb.hSpan(3).hAlign(131072).hGrab().label(0, "\u30a6\u30a4\u30f3\u30c9\u30a6\u30b5\u30a4\u30ba:");
        this._windowSizeText = gb.hSpan(2).hAlign(4).hGrab().tabAfter((Control)this._bitRateText).text(2048, "");
        gb.hSpan(2).hAlign(4).hGrab().label(0, "\u30d5\u30ec\u30fc\u30e0");
        gb.hSpan(3).hAlign(4).hGrab().button(8, "").setVisible(false);
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!AVIVideoCompressorWizardPage.this._updatingControls) {
                    AVIVideoCompressorWizardPage.this.updateSettings();
                }
            }
        };
        this._qualityText.addModifyListener(modifyListener);
        this._keyFrameText.addModifyListener(modifyListener);
        this._PFramesText.addModifyListener(modifyListener);
        this._bitRateText.addModifyListener(modifyListener);
        this._windowSizeText.addModifyListener(modifyListener);
        this._configButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AVIVideoCompressorWizardPage.this.config();
            }
        });
        this._resetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AVIVideoCompressorWizardPage.this.reset();
            }
        });
        this._aboutButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AVIVideoCompressorWizardPage.this.about();
            }
        });
        this._compressorCombo.setVisibleItemCount(20);
        this._compressorCombo.select(this._selectedIndex);
        this._compressorCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AVIVideoCompressorWizardPage.this._selectedIndex = AVIVideoCompressorWizardPage.this._compressorCombo.getSelectionIndex();
                AVIVideoCompressorWizardPage.this.updateControls();
            }
        });
        this.updateControls();
        Composite grid = gb.getComposite();
        grid.setTabList(gb.getTabList());
        this.setControl((Control)grid);
    }

    private void updateText(Text control, boolean enabled, String text) {
        control.setEnabled(enabled);
        control.setText(enabled ? text : "");
    }

    private void updateControls() {
        this._updatingControls = true;
        try {
            WindowsDirectShowOutput.VideoCompressorDescriptor desc = this._compressors.get(this._selectedIndex);
            WindowsDirectShowOutput.VideoCompressorSettings settings = this._settingsCache.get(this._selectedIndex);
            if (settings == null) {
                settings = new WindowsDirectShowOutput.VideoCompressorSettings(desc);
                this._settingsCache.put(this._selectedIndex, settings);
            }
            this.updateText(this._qualityText, desc.canQuality, String.valueOf((int)(settings.quality * 100.0)));
            this.updateText(this._keyFrameText, desc.canKeyFrame, String.valueOf(settings.keyFrameRate));
            this.updateText(this._PFramesText, desc.canBFrame, String.valueOf(settings.PFramesPerKey));
            this.updateText(this._bitRateText, desc.canCrunch, String.valueOf(settings.bitRate >> 13));
            this.updateText(this._windowSizeText, desc.canWindow, String.valueOf(settings.windowSize));
            boolean enableReset = desc.canQuality | desc.canKeyFrame | desc.canBFrame | desc.canCrunch | desc.canWindow | desc.canConfigDialog;
            this._configButton.setEnabled(desc.canConfigDialog);
            this._resetButton.setEnabled(enableReset);
            this._aboutButton.setEnabled(desc.canAboutDialog);
            this.setErrorMessage(null);
            this.setPageComplete(true);
        }
        finally {
            this._updatingControls = false;
        }
    }

    private void updateSettings() {
        this.setPageComplete(false);
        WindowsDirectShowOutput.VideoCompressorDescriptor desc = this._compressors.get(this._selectedIndex);
        WindowsDirectShowOutput.VideoCompressorSettings settings = this._settingsCache.get(this._selectedIndex);
        double quality = settings.quality;
        if (desc.canQuality) {
            try {
                quality = Integer.parseInt(this._qualityText.getText().trim());
            }
            catch (NumberFormatException numberFormatException) {
                quality = -1.0;
            }
            if (quality < 0.0 || quality > 100.0) {
                this.setErrorMessage("\u5727\u7e2e\u306e\u54c1\u8cea\u306b\u306f0\u304b\u3089100\u307e\u3067\u306e\u6574\u6570\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                return;
            }
            quality /= 100.0;
        }
        int keyFrameRate = settings.keyFrameRate;
        if (desc.canKeyFrame) {
            try {
                keyFrameRate = Integer.parseInt(this._keyFrameText.getText().trim());
            }
            catch (NumberFormatException numberFormatException) {
                keyFrameRate = -1;
            }
            if (keyFrameRate < 0) {
                this.setErrorMessage("\u30ad\u30fc\u30d5\u30ec\u30fc\u30e0\u306b\u306f0\u4ee5\u4e0a\u306e\u6574\u6570\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                return;
            }
        }
        int PFramesPerKey = settings.PFramesPerKey;
        if (desc.canBFrame) {
            try {
                PFramesPerKey = Integer.parseInt(this._PFramesText.getText().trim());
            }
            catch (NumberFormatException numberFormatException) {
                PFramesPerKey = -1;
            }
            if (PFramesPerKey < 0) {
                this.setErrorMessage("\uff77\uff70\uff8c\uff9a\uff70\uff91\u6bce\u306eP\uff8c\uff9a\uff70\uff91\u306b\u306f0\u4ee5\u4e0a\u306e\u6574\u6570\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                return;
            }
        }
        long bitRate = settings.bitRate;
        if (desc.canCrunch) {
            try {
                bitRate = Integer.parseInt(this._bitRateText.getText().trim());
            }
            catch (NumberFormatException numberFormatException) {
                bitRate = -1L;
            }
            if (bitRate < 0L) {
                this.setErrorMessage("\u30c7\u30fc\u30bf\u30ec\u30fc\u30c8\u306b\u306f0\u4ee5\u4e0a\u306e\u6574\u6570\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                return;
            }
            bitRate = Math.min(bitRate << 13, Integer.MAX_VALUE);
        }
        long windowSize = settings.windowSize;
        if (desc.canWindow) {
            try {
                windowSize = Long.parseLong(this._windowSizeText.getText().trim());
            }
            catch (NumberFormatException numberFormatException) {
                windowSize = 0L;
            }
            if (windowSize <= 0L) {
                this.setErrorMessage("\u30a6\u30a4\u30f3\u30c9\u30a6\u30b5\u30a4\u30ba\u306b\u306f1\u4ee5\u4e0a\u306e\u6574\u6570\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                return;
            }
        }
        settings.quality = quality;
        settings.keyFrameRate = keyFrameRate;
        settings.PFramesPerKey = PFramesPerKey;
        settings.bitRate = bitRate;
        settings.windowSize = windowSize;
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }

    private void reset() {
        WindowsDirectShowOutput.VideoCompressorDescriptor desc = this._compressors.get(this._selectedIndex);
        this._settingsCache.put(this._selectedIndex, new WindowsDirectShowOutput.VideoCompressorSettings(desc));
        this.updateControls();
    }

    private void config() {
        WindowsDirectShowOutput.VideoCompressorDescriptor desc = this._compressors.get(this._selectedIndex);
        WindowsDirectShowOutput.VideoCompressorSettings settings = this._settingsCache.get(this._selectedIndex);
        WindowsDirectShowOutput.openVideoCompressorConfigDialog((Composition)this._composition, (WindowsDirectShowOutput.VideoCompressorDescriptor)desc, (WindowsDirectShowOutput.VideoCompressorSettings)settings, (long)this.getHWND());
    }

    private void about() {
        WindowsDirectShowOutput.VideoCompressorDescriptor desc = this._compressors.get(this._selectedIndex);
        WindowsDirectShowOutput.openVideoCompressorAboutDialog((WindowsDirectShowOutput.VideoCompressorDescriptor)desc, (long)this.getHWND());
    }

    private long getHWND() {
        try {
            Shell shell = this.getShell();
            Class<?> clazz = shell.getClass();
            Field handleField = clazz.getField("handle");
            return ((Integer)handleField.get(shell)).intValue();
        }
        catch (NoSuchFieldException e) {
            throw new JavieRuntimeException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new JavieRuntimeException((Throwable)e);
        }
    }
}

