/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.actions;

import ch.kuramo.javie.app.UIUtil;
import ch.kuramo.javie.app.project.NewFileItemsOperation;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.views.ProjectView;
import ch.kuramo.javie.core.Folder;
import ch.kuramo.javie.core.Util;
import java.io.File;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IWorkbenchWindow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewFileItemsAction
extends Action {
    private final IWorkbenchWindow window;

    public NewFileItemsAction(IWorkbenchWindow window) {
        super("\u30d5\u30a1\u30a4\u30eb...");
        this.window = window;
        this.setId("ch.kuramo.javie.app.commands.newFileItems");
        this.setActionDefinitionId("ch.kuramo.javie.app.commands.newFileItems");
    }

    public void run() {
        ProjectManager pm = ProjectManager.forWorkbenchWindow(this.window);
        if (pm == null) {
            return;
        }
        List<File> files = this.showFileDialog();
        if (files == null) {
            return;
        }
        ProjectView projectView = (ProjectView)((Object)UIUtil.showView(this.window.getActivePage(), "ch.kuramo.javie.app.views.projectView"));
        Folder parent = projectView.getItemTreeInsertionPoint();
        pm.postOperation(new NewFileItemsOperation(pm, parent, files));
    }

    private List<File> showFileDialog() {
        String[] filterNames = new String[]{"All Files (*)"};
        String[] filterExtensions = new String[]{"*"};
        String platform = SWT.getPlatform();
        if (platform.equals("win32") || platform.equals("wpf")) {
            filterNames = new String[]{"All Files (*.*)"};
            filterExtensions = new String[]{"*.*"};
        }
        FileDialog dialog = new FileDialog(this.window.getShell(), 0x10001002);
        dialog.setFilterNames(filterNames);
        dialog.setFilterExtensions(filterExtensions);
        if (dialog.open() == null) {
            return null;
        }
        List files = Util.newList();
        String parent = dialog.getFilterPath();
        String[] stringArray = dialog.getFileNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String filename = stringArray[n2];
            files.add(new File(parent, filename));
            ++n2;
        }
        return files;
    }
}

