/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.player;

import ch.kuramo.javie.api.Color;
import ch.kuramo.javie.api.Resolution;
import ch.kuramo.javie.api.Size2i;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.app.InjectorHolder;
import ch.kuramo.javie.app.player.GLCanvasFactory;
import ch.kuramo.javie.app.player.MovingAverage;
import ch.kuramo.javie.app.player.PlayerThreadEvent;
import ch.kuramo.javie.app.player.PlayerThreadListener;
import ch.kuramo.javie.app.player.TimeKeeper;
import ch.kuramo.javie.core.CompositionItem;
import ch.kuramo.javie.core.FrameDuration;
import ch.kuramo.javie.core.ImageSequenceItem;
import ch.kuramo.javie.core.MediaInput;
import ch.kuramo.javie.core.MediaInputPlaceholder;
import ch.kuramo.javie.core.MediaItem;
import ch.kuramo.javie.core.SolidColorItem;
import ch.kuramo.javie.core.TimeCode;
import ch.kuramo.javie.core.VideoBuffer;
import ch.kuramo.javie.core.misc.AtiIntelLock;
import ch.kuramo.javie.core.services.GLGlobal;
import ch.kuramo.javie.core.services.RenderContext;
import com.google.inject.Inject;
import com.sun.opengl.util.gl2.GLUT;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import javax.media.opengl.GL;
import javax.media.opengl.GL2;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.awt.GLCanvas;
import javax.media.opengl.glu.GLU;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ScrollBar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VideoCanvas
extends Thread
implements GLEventListener {
    private static final Logger _logger = LoggerFactory.getLogger(VideoCanvas.class);
    private static final boolean COCOA = SWT.getPlatform().equals("cocoa");
    private static final Time TIME0 = Time.fromFrameNumber((long)0L, (Time)FrameDuration.FPS_29_97);
    private final MediaItem _mediaItem;
    private final MediaInput _mediaInput;
    private final TimeKeeper _timeKeeper;
    private GLCanvasFactory.GLCanvasRecord _glCanvasRecord;
    private final ScrolledComposite _scrolled;
    private final GLCanvas _canvas;
    private GLU _glu;
    private GLUT _glut;
    private final AtomicReference<Object[]> _videoBufferAndTimeRef = new AtomicReference();
    private final Queue<VideoBuffer> _oldVideoBuffers = new ConcurrentLinkedQueue<VideoBuffer>();
    private volatile Time _frameDuration;
    private volatile Resolution _resolution = Resolution.FULL;
    private double _zoom;
    private volatile boolean _showInfo;
    private Size2i _canvasSize;
    private int _hScroll;
    private int _vScroll;
    private int _scrollAreaHeight;
    private ControlListener _resizeListener;
    private volatile int[] _viewport = new int[4];
    private final Object _monitor = new Object();
    private boolean _glInitialized;
    private volatile boolean _playing;
    private volatile boolean _forceRender;
    private volatile boolean _finished;
    private volatile boolean _displaying;
    private final ListenerList _playerThreadListeners = new ListenerList();
    private final MovingAverage _delayAverage = new MovingAverage(30);
    private final MovingAverage _frameDurationAvg = new MovingAverage(30);
    @Inject
    private RenderContext _context;
    @Inject
    private GLGlobal _glGlobal;
    private final boolean _intel;
    private final AtiIntelLock _atiIntelLock;

    public VideoCanvas(Composite parent, MediaItem mediaItem, TimeKeeper timeKeeper) {
        super("VideoCanvas: " + mediaItem.getName());
        MediaInput mediaInput = mediaItem.getMediaInput();
        if (mediaInput == null) {
            throw new IllegalArgumentException("no MediaInput is available");
        }
        if (!mediaInput.isVideoAvailable()) {
            throw new IllegalArgumentException("no video is available");
        }
        InjectorHolder.getInjector().injectMembers((Object)this);
        this._mediaItem = mediaItem;
        this._mediaInput = mediaInput;
        this._timeKeeper = timeKeeper;
        this._glCanvasRecord = GLCanvasFactory.getFactory().getGLCanvas(parent);
        this._scrolled = this._glCanvasRecord.scrolled;
        this._canvas = this._glCanvasRecord.glCanvas;
        this._canvas.addGLEventListener((GLEventListener)this);
        if (COCOA) {
            this.cocoaListenToScrollAndResize();
            this._scrollAreaHeight = this._scrolled.getClientArea().height;
        } else {
            this.listenToResize();
        }
        this.setZoom(1.0);
        this._intel = this._glGlobal.isIntel();
        this._atiIntelLock = AtiIntelLock.get((GLGlobal)this._glGlobal);
    }

    public Control getControl() {
        return this._scrolled;
    }

    private void cleanup() {
        this._canvas.removeGLEventListener((GLEventListener)this);
        if (this._resizeListener != null) {
            this._scrolled.removeControlListener(this._resizeListener);
            this._resizeListener = null;
        }
        if (this._glCanvasRecord != null) {
            GLCanvasFactory.getFactory().releaseGLCanvas(this._glCanvasRecord);
            this._glCanvasRecord = null;
        }
    }

    private void cocoaListenToScrollAndResize() {
        final ScrollBar hBar = this._scrolled.getHorizontalBar();
        final ScrollBar vBar = this._scrolled.getVerticalBar();
        hBar.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int scroll = hBar.getSelection();
                if (VideoCanvas.this._hScroll != scroll) {
                    VideoCanvas.this._hScroll = scroll;
                    VideoCanvas.this.updateViewport();
                }
            }
        });
        vBar.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int scroll = vBar.getSelection();
                if (VideoCanvas.this._vScroll != scroll) {
                    VideoCanvas.this._vScroll = scroll;
                    VideoCanvas.this.updateViewport();
                }
            }
        });
        this._scrolled.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                if (VideoCanvas.this._zoom == 0.0) {
                    VideoCanvas.this.fitCanvasToScrollArea();
                }
                e.display.asyncExec(new Runnable(){

                    public void run() {
                        if (VideoCanvas.this._scrolled.isDisposed()) {
                            return;
                        }
                        int height = ((VideoCanvas)(this).VideoCanvas.this)._scrolled.getClientArea().height;
                        int hScroll = hBar.getSelection();
                        int vScroll = vBar.getSelection();
                        if (VideoCanvas.this._scrollAreaHeight != height || VideoCanvas.this._hScroll != hScroll || VideoCanvas.this._vScroll != vScroll) {
                            VideoCanvas.this._scrollAreaHeight = height;
                            VideoCanvas.this._hScroll = hScroll;
                            VideoCanvas.this._vScroll = vScroll;
                            VideoCanvas.this.updateViewport();
                        }
                    }
                });
            }
        });
    }

    private void listenToResize() {
        this._resizeListener = new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                if (VideoCanvas.this._zoom == 0.0) {
                    VideoCanvas.this.fitCanvasToScrollArea();
                }
                e.display.asyncExec(new Runnable(){

                    public void run() {
                        if (!VideoCanvas.this._scrolled.isDisposed()) {
                            ((VideoCanvas)(this).VideoCanvas.this)._glCanvasRecord.awtFrame.repaint();
                        }
                    }
                });
            }
        };
        this._scrolled.addControlListener(this._resizeListener);
    }

    public void setFrameDuration(Time frameDuration) {
        this._frameDuration = frameDuration;
    }

    public Resolution getResolution() {
        return this._resolution;
    }

    public void setResolution(Resolution resolution) {
        if (resolution != null && !resolution.equals((Object)this._resolution) || resolution == null && this._resolution != null) {
            this._resolution = resolution;
            this.forceRender();
        }
    }

    public double getZoom() {
        return this._zoom;
    }

    public void setZoom(double zoom) {
        if (this._zoom != zoom) {
            this._zoom = zoom;
            if (zoom == 0.0) {
                this._scrolled.setMinSize(1, 1);
                this.fitCanvasToScrollArea();
            } else {
                VideoBounds bounds = this._mediaInput.getVideoFrameBounds();
                int w = (int)((double)bounds.width * zoom);
                int h = (int)((double)bounds.height * zoom);
                this._scrolled.setMinSize(w, h);
                this.setCanvasSize(w, h);
            }
        }
    }

    public boolean isShowInfo() {
        return this._showInfo;
    }

    public void setShowInfo(boolean showInfo) {
        if (showInfo != this._showInfo) {
            this._showInfo = showInfo;
            this._canvas.repaint();
        }
    }

    private void fitCanvasToScrollArea() {
        int h;
        int w;
        Rectangle scrollArea = this._scrolled.getClientArea();
        VideoBounds videoBounds = this._mediaInput.getVideoFrameBounds();
        int availableWidth = scrollArea.width - 10;
        int availableHeight = scrollArea.height - 10;
        double scrollAspect = (double)availableWidth / (double)availableHeight;
        double videoAspect = (double)videoBounds.width / (double)videoBounds.height;
        if (scrollAspect > videoAspect) {
            w = (int)((double)availableHeight * videoAspect);
            h = availableHeight;
        } else {
            w = availableWidth;
            h = (int)((double)availableWidth / videoAspect);
        }
        this.setCanvasSize(w, h);
    }

    private void setCanvasSize(final int width, final int height) {
        this._canvasSize = new Size2i(width, height);
        this.updateViewport();
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                Dimension size = VideoCanvas.this._canvas.getPreferredSize();
                if (size.width != width || size.height != height) {
                    VideoCanvas.this._canvas.setPreferredSize(new Dimension(width, height));
                    VideoCanvas.this._canvas.invalidate();
                    VideoCanvas.this._canvas.getParent().validate();
                }
            }
        });
    }

    private void updateViewport() {
        int[] nArray = new int[4];
        nArray[2] = this._canvasSize.width;
        nArray[3] = this._canvasSize.height;
        int[] viewport = nArray;
        if (COCOA) {
            viewport[0] = -this._hScroll;
            if (this._scrollAreaHeight < this._canvasSize.height) {
                viewport[1] = this._vScroll - this._canvasSize.height + this._scrollAreaHeight;
            }
        }
        if (!Arrays.equals(this._viewport, viewport)) {
            this._viewport = viewport;
            this._canvas.repaint();
        }
    }

    public void init(GLAutoDrawable drawable) {
        this._atiIntelLock.lock();
        try {
            GL2 gl = drawable.getGL().getGL2();
            this._glu = GLU.createGLU((GL)gl);
            this._glut = new GLUT();
            gl.glEnable(34037);
            gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
            gl.glClear(16384);
            gl.glMatrixMode(5888);
            gl.glLoadIdentity();
            this._glInitialized = true;
        }
        finally {
            this._atiIntelLock.unlock();
        }
    }

    public void display(GLAutoDrawable drawable) {
        if (this._finished) {
            return;
        }
        if (!this._glInitialized) {
            this.init(drawable);
        }
        Object[] vbAndTime = null;
        this._displaying = true;
        this._atiIntelLock.lock();
        try {
            GL2 gl = drawable.getGL().getGL2();
            vbAndTime = this._videoBufferAndTimeRef.getAndSet(null);
            if (vbAndTime == null) {
                return;
            }
            VideoBuffer vb = (VideoBuffer)vbAndTime[0];
            int[] vp = this._viewport;
            gl.glViewport(vp[0], vp[1], vp[2], vp[3]);
            Size2i imageSize = vb.getImageSize();
            int w = imageSize.width;
            int h = imageSize.height;
            gl.glMatrixMode(5889);
            gl.glLoadIdentity();
            this._glu.gluOrtho2D(0.0f, (float)w, (float)h, 0.0f);
            gl.glBindTexture(34037, vb.getTexture());
            gl.glBegin(7);
            gl.glTexCoord2f(0.0f, 0.0f);
            gl.glVertex2f(0.0f, 0.0f);
            gl.glTexCoord2f((float)w, 0.0f);
            gl.glVertex2f((float)w, 0.0f);
            gl.glTexCoord2f((float)w, (float)h);
            gl.glVertex2f((float)w, (float)h);
            gl.glTexCoord2f(0.0f, (float)h);
            gl.glVertex2f(0.0f, (float)h);
            gl.glEnd();
            gl.glBindTexture(34037, 0);
            if (this._showInfo) {
                gl.glPushAttrib(24577);
                gl.glLoadIdentity();
                this._glu.gluOrtho2D(0.0f, (float)vp[2], (float)vp[3], 0.0f);
                this.drawInfo(gl, (Time)vbAndTime[1]);
                gl.glPopAttrib();
            }
            gl.glFinish();
        }
        finally {
            this._atiIntelLock.unlock();
            if (vbAndTime != null && !this._videoBufferAndTimeRef.compareAndSet(null, vbAndTime)) {
                this._oldVideoBuffers.add((VideoBuffer)vbAndTime[0]);
            }
            this._displaying = false;
        }
    }

    private void drawInfo(GL2 gl, Time time) {
        ArrayList<String> info = new ArrayList<String>();
        VideoBounds bounds = this._mediaInput.getVideoFrameBounds();
        Time frameDuration = this._mediaInput.getVideoFrameDuration();
        if (this._mediaItem instanceof CompositionItem) {
            String bpc;
            switch (((CompositionItem)this._mediaItem).getComposition().getColorMode()) {
                case RGBA8: {
                    bpc = "8 bpc";
                    break;
                }
                case RGBA16: {
                    bpc = "16 bpc";
                    break;
                }
                case RGBA16_FLOAT: {
                    bpc = "16 bpc float";
                    break;
                }
                case RGBA32_FLOAT: {
                    bpc = "32 bpc float";
                    break;
                }
                default: {
                    bpc = "unknown bpc";
                }
            }
            info.add(String.format("Composition: %d x %d, %s", bounds.width, bounds.height, bpc));
        } else if (this._mediaItem instanceof SolidColorItem) {
            Color color = ((SolidColorItem)this._mediaItem).getColor();
            info.add(String.format("Solid Color: %d x %d, #%02x%02x%02x", bounds.width, bounds.height, (int)(color.r * 255.0), (int)(color.g * 255.0), (int)(color.b * 255.0)));
        } else if (this._mediaItem.getMediaInput() instanceof MediaInputPlaceholder) {
            info.add(String.format("Placeholder: %d x %d", bounds.width, bounds.height));
        } else if (this._mediaItem instanceof ImageSequenceItem) {
            info.add(String.format("Image Sequence: %d x %d", bounds.width, bounds.height));
        } else if (this._mediaInput.getVideoFrameDuration() != null) {
            info.add(String.format("Video: %d x %d", bounds.width, bounds.height));
        } else {
            info.add(String.format("Image: %d x %d", bounds.width, bounds.height));
        }
        if (frameDuration != null) {
            Time duration = this._mediaInput.getDuration();
            info.add(String.format("Frame: %d / %d", time.toFrameNumber(frameDuration), duration.toFrameNumber(frameDuration)));
            info.add(String.format("Time: %s / %s", TimeCode.toTimeCode((Time)time, (Time)frameDuration), TimeCode.toTimeCode((Time)duration, (Time)frameDuration)));
            info.add(String.format("FPS: %.2f / %.2f", 1.0 / this._frameDurationAvg.getSampledAverage(), 1.0 / frameDuration.toSecond()));
        }
        int infoWidth = 0;
        int infoHeight = info.size() * 12;
        for (String s : info) {
            infoWidth = Math.max(infoWidth, this._glut.glutBitmapLength(6, s));
        }
        infoWidth += 2;
        gl.glEnable(3042);
        gl.glBlendFunc(770, 771);
        gl.glColor4f(0.0f, 0.0f, 0.0f, 0.4f);
        gl.glBegin(7);
        gl.glVertex2f(10.0f, 10.0f);
        gl.glVertex2f((float)(10 + infoWidth), 10.0f);
        gl.glVertex2f((float)(10 + infoWidth), (float)(10 + infoHeight));
        gl.glVertex2f(10.0f, (float)(10 + infoHeight));
        gl.glEnd();
        gl.glDisable(3042);
        gl.glColor4f(0.0f, 1.0f, 0.0f, 1.0f);
        int i = 0;
        for (String s : info) {
            gl.glRasterPos2f(11.0f, (float)(20 + i++ * 12));
            this._glut.glutBitmapString(6, s);
        }
    }

    public void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {
    }

    public void dispose(GLAutoDrawable drawable) {
    }

    /*
     * Exception decompiling
     */
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [39[UNCONDITIONALDOLOOP]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceRender() {
        Object object = this._monitor;
        synchronized (object) {
            this._forceRender = true;
            this._monitor.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void play(boolean play) {
        if (this._playing == play) {
            return;
        }
        Object object = this._monitor;
        synchronized (object) {
            this._playing = play;
            this._monitor.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        if (this._finished) {
            return;
        }
        Object object = this._monitor;
        synchronized (object) {
            this._finished = true;
            this._monitor.notify();
        }
        try {
            this.join();
        }
        catch (InterruptedException interruptedException) {}
        this.cleanup();
    }

    private void glFinish(GL2 gl, VideoBuffer vb) {
        if (!this._intel) {
            gl.glFinish();
            return;
        }
        gl.glFramebufferTexture2D(36160, 36064, 34037, vb.getTexture(), 0);
        gl.glFinish();
        gl.glFramebufferTexture2D(36160, 36064, 34037, 0, 0);
    }

    private void setTexParametersForDisplay(VideoBuffer vb, Resolution resolution, GL2 gl) {
        gl.glBindTexture(34037, vb.getTexture());
        if (Resolution.FULL.equals((Object)resolution)) {
            gl.glTexParameteri(34037, 10241, 9728);
            gl.glTexParameteri(34037, 10240, 9728);
        } else {
            gl.glTexParameteri(34037, 10241, 9729);
            gl.glTexParameteri(34037, 10240, 9729);
            gl.glTexParameteri(34037, 10242, 33071);
            gl.glTexParameteri(34037, 10243, 33071);
        }
        gl.glBindTexture(34037, 0);
    }

    private Resolution autoResolution(Resolution prevResolution, double avgThreshold) {
        if (prevResolution == null) {
            return Resolution.FULL;
        }
        if (this._delayAverage.getAverage() > avgThreshold) {
            if (prevResolution.equals((Object)Resolution.FULL)) {
                this._delayAverage.reset();
                return Resolution.HALF;
            }
            if (prevResolution.equals((Object)Resolution.HALF)) {
                this._delayAverage.reset();
                return Resolution.ONETHIRD;
            }
            return Resolution.QUARTER;
        }
        return prevResolution;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Time[] waitForRendering() {
        if (!this._playing && !this._forceRender) {
            Object object = this._monitor;
            synchronized (object) {
                while (!(this._playing || this._forceRender || this._finished)) {
                    try {
                        this._monitor.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        if (this._finished) {
            return null;
        }
        Time[] timeArray = this._timeKeeper.getTimeAndBase();
        return timeArray;
    }

    private void sleep(Time time) {
        if (time.timeValue > 0L) {
            try {
                long sleep = (long)(time.toSecond() * 1.0E9);
                Thread.sleep(sleep / 1000000L, (int)(sleep % 1000000L));
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private Time calcDelay(Time[] timeAndBase) {
        Time[] curTimeAndBase = this._timeKeeper.getTimeAndBase();
        if (curTimeAndBase[1] != timeAndBase[1]) {
            return TIME0;
        }
        Time delay = curTimeAndBase[0].subtract(timeAndBase[0]);
        return delay.timeValue > 0L ? delay : TIME0;
    }

    private boolean sleepUntilFrameTime(Time frameTime, Time tkBase) {
        while (this._playing && !this._finished) {
            Time[] curTimeAndBase = this._timeKeeper.getTimeAndBase();
            if (curTimeAndBase[1] != tkBase) {
                return false;
            }
            Time sleepTime = frameTime.subtract(curTimeAndBase[0]);
            if (sleepTime.timeValue <= 0L) {
                return true;
            }
            this.sleep(sleepTime);
        }
        return false;
    }

    private void disposeOldVideoBuffers() {
        Iterator it = this._oldVideoBuffers.iterator();
        while (it.hasNext()) {
            VideoBuffer old = (VideoBuffer)it.next();
            old.dispose();
            it.remove();
        }
    }

    public void addPlayerThreadListener(PlayerThreadListener listener) {
        this._playerThreadListeners.add((Object)listener);
    }

    public void removePlayerThreadListener(PlayerThreadListener listener) {
        this._playerThreadListeners.remove((Object)listener);
    }

    private void fireThreadRender(Time time) {
        PlayerThreadEvent event = new PlayerThreadEvent(this, time);
        Object[] objectArray = this._playerThreadListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object l = objectArray[n2];
            ((PlayerThreadListener)l).threadRender(event);
            ++n2;
        }
    }

    private void fireThreadEndOfDuration(Time time) {
        PlayerThreadEvent event = new PlayerThreadEvent(this, time);
        Object[] objectArray = this._playerThreadListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object l = objectArray[n2];
            ((PlayerThreadListener)l).threadEndOfDuration(event);
            ++n2;
        }
    }
}

