/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.project;

import ch.kuramo.javie.app.PropertyUtil;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.project.ProjectOperation;
import ch.kuramo.javie.core.Effect;
import ch.kuramo.javie.core.EffectableLayer;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.Project;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyEffectPropertyOperation<T>
extends ProjectOperation {
    private final String _compId;
    private final String _layerId;
    private final int _effectIndex;
    private final String _property;
    private final T _oldValue;
    private final T _newValue;

    public ModifyEffectPropertyOperation(ProjectManager pm, EffectableLayer layer, Effect effect, String property, T newValue, String label) {
        super(pm, label);
        LayerComposition comp = pm.checkLayer((Layer)layer);
        this._compId = comp.getId();
        this._layerId = layer.getId();
        this._effectIndex = layer.getEffects().indexOf(effect);
        if (this._effectIndex == -1) {
            throw new IllegalArgumentException();
        }
        this._property = property;
        this._oldValue = PropertyUtil.getProperty(effect, property);
        this._newValue = newValue;
        this._noEffect = this._newValue == this._oldValue || this._newValue != null && this._newValue.equals(this._oldValue);
    }

    @Override
    protected IStatus executeOrRedo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        this.modifyProperty(this._newValue, project, pm);
        return Status.OK_STATUS;
    }

    @Override
    protected IStatus undo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        this.modifyProperty(this._oldValue, project, pm);
        return Status.OK_STATUS;
    }

    private void modifyProperty(T value, Project project, ProjectManager pm) {
        LayerComposition comp = (LayerComposition)project.getComposition(this._compId);
        EffectableLayer layer = (EffectableLayer)comp.getLayer(this._layerId);
        Effect effect = (Effect)layer.getEffects().get(this._effectIndex);
        PropertyUtil.setProperty(effect, this._property, value);
        if (pm != null) {
            pm.fireEffectPropertyChange(layer, this._effectIndex, this._property);
        }
    }
}

