/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.views.layercomp;

import ch.kuramo.javie.api.Vec3d;
import ch.kuramo.javie.app.Activator;
import ch.kuramo.javie.app.views.layercomp.AnimatableValueElement;
import ch.kuramo.javie.app.views.layercomp.AnimatableVec3dElementDelegate;
import ch.kuramo.javie.app.views.layercomp.Switch;
import ch.kuramo.javie.app.views.layercomp.SwitchGroup;
import ch.kuramo.javie.core.AnimatableVec3d;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;

class LayerScaleElementDelegate
extends AnimatableVec3dElementDelegate {
    private static final Image linkImage = Activator.getDefault().getImageRegistry().get("IMG_SWITCH_LINK");
    private final SwitchGroup linkSwitch = new SwitchGroup();
    private boolean linked = true;

    LayerScaleElementDelegate(AnimatableValueElement element, String name, AnimatableVec3d avalue, boolean threeD, String unit) {
        super(element, name, avalue, threeD, unit);
        this.linkSwitch.add(new Switch(){

            public void mouseDown(MouseEvent event) {
                LayerScaleElementDelegate.this.linked = !LayerScaleElementDelegate.this.linked;
                LayerScaleElementDelegate.this.linkSwitch.redraw((Control)event.widget);
            }

            public boolean hasBorder() {
                return true;
            }

            public Image getImage() {
                return LayerScaleElementDelegate.this.linked ? linkImage : null;
            }
        });
    }

    public void paintColumn(Event event) {
        if (event.index == 1) {
            this.linkSwitch.paint(event);
        }
        super.paintColumn(event);
    }

    protected void drawValue(GC gc, int x, int y, int height, boolean focused) {
        super.drawValue(gc, x + 18, y, height, focused);
    }

    protected int drawValue(GC gc, int x, int y, int height, int valueIndex, double value) {
        return super.drawValue(gc, valueIndex == 0 ? x + 18 : x, y, height, valueIndex, value);
    }

    public void mouseDown(MouseEvent event, int columnIndex) {
        if (columnIndex == 1) {
            this.linkSwitch.mouseDown(event);
        }
        super.mouseDown(event, columnIndex);
    }

    public CellEditor getCellEditor(int columnIndex) {
        if (columnIndex == 1) {
            if (this.editor == null) {
                this.editor = new ScaleCellEditor((Composite)this.element.viewer.getTree(), 2052);
            }
            return this.editor;
        }
        return null;
    }

    protected void modifyValue(Vec3d newValue, String relation) {
        if (this.linked) {
            double[] oldArray = new double[]{((Vec3d)this.value).x, ((Vec3d)this.value).y, ((Vec3d)this.value).z};
            double[] newArray = new double[]{newValue.x, newValue.y, newValue.z};
            double ratio = newArray[this.valueIndex] / oldArray[this.valueIndex];
            int i = 0;
            while (i < 3) {
                if (i != this.valueIndex) {
                    if (oldArray[i] == oldArray[this.valueIndex]) {
                        newArray[i] = newArray[this.valueIndex];
                    } else if (!Double.isNaN(ratio) && !Double.isInfinite(ratio)) {
                        int n = i;
                        newArray[n] = newArray[n] * ratio;
                    }
                }
                ++i;
            }
            newValue = new Vec3d(newArray[0], newArray[1], newArray[2]);
        }
        super.modifyValue(newValue, relation);
    }

    protected class ScaleCellEditor
    extends AnimatableVec3dElementDelegate.Vec3dCellEditor {
        protected ScaleCellEditor(Composite parent, int style) {
            super(parent, style);
        }

        protected Control createControl(Composite parent) {
            Control control = super.createControl(parent);
            FormData data = (FormData)this.text.getLayoutData();
            data.left.offset += 18;
            data.right.offset += 18;
            if (WIN32) {
                control.addPaintListener(new PaintListener(){

                    public void paintControl(PaintEvent e) {
                        Event event = new Event();
                        event.gc = e.gc;
                        event.widget = e.widget;
                        event.x = e.x;
                        event.y = e.y;
                        LayerScaleElementDelegate.this.linkSwitch.paint(event);
                    }
                });
            }
            return control;
        }
    }
}

