/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.widgets;

import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.core.FrameDuration;

public class FrameRateComboUtil {
    private static final Time[] frameDurations = FrameDuration.values();
    private static final String[] comboItems = new String[frameDurations.length];

    static {
        int i = 0;
        while (i < frameDurations.length) {
            FrameRateComboUtil.comboItems[i] = FrameRateComboUtil.formatComboItem(frameDurations[i]);
            ++i;
        }
    }

    public static String[] getComboItems() {
        return (String[])comboItems.clone();
    }

    public static Time toFrameDuration(String comboItem) {
        int i = 0;
        while (i < comboItems.length) {
            if (comboItem.equals(comboItems[i])) {
                return frameDurations[i];
            }
            ++i;
        }
        int timeValue = (int)(1.0E7 / Double.parseDouble(comboItem));
        return new Time((long)timeValue, 10000000);
    }

    public static String toComboItem(Time frameDuration) {
        int i = 0;
        while (i < frameDurations.length) {
            if (frameDuration.equals((Object)frameDurations[i])) {
                return comboItems[i];
            }
            ++i;
        }
        return FrameRateComboUtil.formatComboItem(frameDuration);
    }

    private static String formatComboItem(Time frameDuration) {
        String item = String.format("%.3f", (double)frameDuration.timeScale / (double)frameDuration.timeValue);
        int i = item.length() - 1;
        while (true) {
            switch (item.charAt(i)) {
                case '0': {
                    break;
                }
                case '.': {
                    return item.substring(0, i);
                }
                default: {
                    return item.substring(0, i + 1);
                }
            }
            --i;
        }
    }

    private FrameRateComboUtil() {
    }
}

