/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal;

import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.core.AbstractItem;
import ch.kuramo.javie.core.ImageSequenceItem;
import ch.kuramo.javie.core.MediaInput;
import ch.kuramo.javie.core.MediaInputPlaceholder;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.ProjectDecodeException;
import ch.kuramo.javie.core.annotations.ProjectElement;
import ch.kuramo.javie.core.internal.ImageSequenceInput;
import ch.kuramo.javie.core.internal.MediaInputPlaceholderImpl;
import ch.kuramo.javie.core.services.MediaFileInputFactory;
import com.google.inject.Inject;
import com.google.inject.Injector;
import java.io.File;
import net.arnx.jsonic.JSONHint;

@ProjectElement(value="imageSequence")
public class ImageSequenceItemImpl
extends AbstractItem
implements ImageSequenceItem {
    private File _file;
    private Time _frameDuration;
    private VideoBounds _videoFrameBounds;
    private MediaInput _mediaInput;
    private final MediaFileInputFactory _mediaFileInputFactory;
    private final Injector _injector;

    @Inject
    public ImageSequenceItemImpl(MediaFileInputFactory mediaFileInputFactory, Injector injector) {
        this._mediaFileInputFactory = mediaFileInputFactory;
        this._injector = injector;
    }

    public void initialize(File file, Time frameDuration) {
        super.initialize();
        ImageSequenceInput input = this._mediaFileInputFactory.get(ImageSequenceInput.class, this.getId(), file);
        if (input != null) {
            input.setVideoFrameDuration(frameDuration);
            this._file = input.getFirstFile();
            this._frameDuration = frameDuration;
            this._videoFrameBounds = input.isVideoAvailable() ? input.getVideoFrameBounds() : null;
            this._mediaInput = input;
            this.setName(this._file.getName());
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    public void dispose() {
        if (this._mediaInput != null) {
            if (!(this._mediaInput instanceof MediaInputPlaceholder)) {
                this._mediaFileInputFactory.release(this.getId());
            }
            this._mediaInput = null;
        }
    }

    public File getFile() {
        return this._file;
    }

    public void setFile(File file) {
        this._file = file;
    }

    public Time getFrameDuration() {
        return this._frameDuration;
    }

    public void setFrameDuration(Time frameDuration) {
        this._frameDuration = frameDuration;
    }

    public VideoBounds getVideoFrameBounds() {
        return this._videoFrameBounds;
    }

    public void setVideoFrameBounds(VideoBounds videoFrameBounds) {
        this._videoFrameBounds = videoFrameBounds;
    }

    @JSONHint(ignore=true)
    public MediaInput getMediaInput() {
        return this._mediaInput;
    }

    public void afterDecode(Project p) throws ProjectDecodeException {
        super.afterDecode(p);
        ImageSequenceInput input = this._mediaFileInputFactory.get(ImageSequenceInput.class, this.getId(), this._file);
        if (input != null) {
            input.setVideoFrameDuration(this._frameDuration);
            this._file = input.getFirstFile();
            this._videoFrameBounds = input.isVideoAvailable() ? input.getVideoFrameBounds() : null;
            this._mediaInput = input;
        } else {
            MediaInputPlaceholderImpl placeholder = (MediaInputPlaceholderImpl)this._injector.getInstance(MediaInputPlaceholderImpl.class);
            placeholder.setVideoFrameBounds(this._videoFrameBounds);
            this._mediaInput = placeholder;
        }
    }

    @JSONHint(ignore=true)
    public String getKind() {
        return "\u30a4\u30e1\u30fc\u30b8\u30b7\u30fc\u30b1\u30f3\u30b9";
    }
}

