/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal;

import ch.kuramo.javie.api.ColorMode;
import ch.kuramo.javie.api.Resolution;
import ch.kuramo.javie.api.Size2i;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.core.AudioBuffer;
import ch.kuramo.javie.core.MediaFileInput;
import ch.kuramo.javie.core.VideoBuffer;
import ch.kuramo.javie.core.services.RenderContext;
import ch.kuramo.javie.core.services.VideoRenderSupport;
import com.google.inject.Inject;
import java.awt.Graphics2D;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.imageio.ImageIO;

public class JavaImageInput
implements MediaFileInput {
    private BufferedImage _srcImage;
    private Size2i _srcSize;
    private VideoBounds _srcBounds;
    private ColorMode _srcColorMode;
    private final ConcurrentMap<Resolution, Entry> _cache = new ConcurrentHashMap<Resolution, Entry>();
    @Inject
    private RenderContext _context;
    @Inject
    private VideoRenderSupport _vrSupport;

    public boolean initialize(File file) {
        try {
            this._srcImage = ImageIO.read(file);
            if (this._srcImage == null) {
                return false;
            }
        }
        catch (IOException iOException) {
            return false;
        }
        this._srcSize = new Size2i(this._srcImage.getWidth(), this._srcImage.getHeight());
        this._srcBounds = new VideoBounds(this._srcImage.getWidth(), this._srcImage.getHeight());
        this._srcColorMode = this._srcImage.getColorModel().getPixelSize() > 32 ? ColorMode.RGBA16 : ColorMode.RGBA8;
        this._cache.put(Resolution.FULL, new Entry(this._srcSize, this.toInternalFormat(this._srcImage, this._srcSize)));
        return true;
    }

    private Object toInternalFormat(BufferedImage srcImage, Size2i scaleTo) {
        int dataType = this._srcColorMode == ColorMode.RGBA16 ? 1 : 0;
        int[] nArray = new int[4];
        nArray[0] = 2;
        nArray[1] = 1;
        nArray[3] = 3;
        WritableRaster wr = Raster.createInterleavedRaster(dataType, scaleTo.width, scaleTo.height, scaleTo.width * 4, 4, nArray, null);
        ComponentColorModel cm = new ComponentColorModel(ColorSpace.getInstance(1000), true, true, 3, dataType);
        BufferedImage tmpImage = new BufferedImage(cm, wr, true, null);
        Graphics2D g = tmpImage.createGraphics();
        g.drawImage(srcImage, 0, 0, scaleTo.width, scaleTo.height, null);
        DataBuffer dataBuffer = tmpImage.getRaster().getDataBuffer();
        return dataType == 1 ? ((DataBufferUShort)dataBuffer).getData() : (short[])((DataBufferByte)dataBuffer).getData();
    }

    public void dispose() {
    }

    public Time getDuration() {
        return null;
    }

    public Time getVideoFrameDuration() {
        return null;
    }

    public VideoBounds getVideoFrameBounds() {
        return this._srcBounds;
    }

    public VideoBuffer getVideoFrame(Time mediaTime) {
        Resolution resolution = this._context.getVideoResolution();
        Entry entry = (Entry)this._cache.get(resolution);
        if (entry == null) {
            Size2i scaleTo = resolution.scale(this._srcSize);
            entry = new Entry(scaleTo, this.toInternalFormat(this._srcImage, scaleTo));
            this._cache.put(resolution, entry);
        }
        ColorMode contextColorMode = this._context.getColorMode();
        VideoBuffer videoBuffer = this._vrSupport.createVideoBuffer(contextColorMode, entry.size);
        videoBuffer.allocateAsTexture();
        this._vrSupport.copyArrayToTexture(entry.array, videoBuffer.getTexture(), this._srcColorMode, entry.size);
        return videoBuffer;
    }

    public boolean isVideoAvailable() {
        return true;
    }

    public boolean isAudioAvailable() {
        return false;
    }

    public AudioBuffer getAudioChunk(Time mediaTime) {
        throw new UnsupportedOperationException("audio is not available");
    }

    private static class Entry {
        private final Size2i size;
        private final Object array;

        private Entry(Size2i size, Object array) {
            this.size = size;
            this.array = array;
        }
    }
}

