/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal;

import ch.kuramo.javie.api.ColorMode;
import ch.kuramo.javie.api.Size2i;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.api.Vec3d;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.core.AbstractComposition;
import ch.kuramo.javie.core.AudioBuffer;
import ch.kuramo.javie.core.Camera;
import ch.kuramo.javie.core.CameraLayer;
import ch.kuramo.javie.core.CollapseTransformation;
import ch.kuramo.javie.core.CoreContext;
import ch.kuramo.javie.core.ExpressionScope;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.LayerNature;
import ch.kuramo.javie.core.MediaInput;
import ch.kuramo.javie.core.MediaLayer;
import ch.kuramo.javie.core.MotionBlur;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.ProjectDecodeException;
import ch.kuramo.javie.core.TrackMatte;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.VideoBuffer;
import ch.kuramo.javie.core.VideoLayerBuffer;
import ch.kuramo.javie.core.VideoLayerComposer;
import ch.kuramo.javie.core.VideoLayerRenderer;
import ch.kuramo.javie.core.WrappedOperation;
import ch.kuramo.javie.core.annotations.ProjectElement;
import ch.kuramo.javie.core.internal.CameraImpl;
import ch.kuramo.javie.core.internal.VideoLayerBufferImpl;
import ch.kuramo.javie.core.internal.VideoLayerComposerImpl;
import ch.kuramo.javie.core.services.AudioRenderSupport;
import ch.kuramo.javie.core.services.RenderContext;
import ch.kuramo.javie.core.services.VideoRenderSupport;
import com.google.inject.Inject;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ProjectElement(value="layerComposition")
public class LayerCompositionImpl
extends AbstractComposition
implements LayerComposition {
    private boolean _shyEnabled = false;
    private boolean _frameBlendEnabled = false;
    private boolean _motionBlurEnabled = false;
    private double _motionBlurShutterAngle = 180.0;
    private double _motionBlurShutterPhase = -90.0;
    private int _motionBlurSamples = 16;
    private final MotionBlur _motionBlur = new MotionBlur(){

        public double getShutterAngle() {
            return LayerCompositionImpl.this._motionBlurShutterAngle;
        }

        public double getShutterPhase() {
            return LayerCompositionImpl.this._motionBlurShutterPhase;
        }

        public int getSamples() {
            return LayerCompositionImpl.this._motionBlurSamples;
        }
    };
    private List<Layer> _layers = Util.newList();
    @Inject
    private RenderContext _context;
    @Inject
    private VideoRenderSupport _vrSupport;
    @Inject
    private AudioRenderSupport _arSupport;

    @Override
    public boolean isShyEnabled() {
        return this._shyEnabled;
    }

    @Override
    public void setShyEnabled(boolean shyEnabled) {
        this._shyEnabled = shyEnabled;
    }

    @Override
    public boolean isFrameBlendEnabled() {
        return this._frameBlendEnabled;
    }

    @Override
    public void setFrameBlendEnabled(boolean frameBlendEnabled) {
        this._frameBlendEnabled = frameBlendEnabled;
    }

    @Override
    public boolean isMotionBlurEnabled() {
        return this._motionBlurEnabled;
    }

    @Override
    public void setMotionBlurEnabled(boolean motionBlurEnabled) {
        this._motionBlurEnabled = motionBlurEnabled;
    }

    @Override
    public double getMotionBlurShutterAngle() {
        return this._motionBlurShutterAngle;
    }

    @Override
    public void setMotionBlurShutterAngle(double motionBlurShutterAngle) {
        this._motionBlurShutterAngle = motionBlurShutterAngle;
    }

    @Override
    public double getMotionBlurShutterPhase() {
        return this._motionBlurShutterPhase;
    }

    @Override
    public void setMotionBlurShutterPhase(double motionBlurShutterPhase) {
        this._motionBlurShutterPhase = motionBlurShutterPhase;
    }

    @Override
    public int getMotionBlurSamples() {
        return this._motionBlurSamples;
    }

    @Override
    public void setMotionBlurSamples(int motionBlurSamples) {
        this._motionBlurSamples = motionBlurSamples;
    }

    @Override
    public List<Layer> getLayers() {
        return this._layers;
    }

    public void setLayers(List<Layer> layers) {
        this._layers = layers;
    }

    @Override
    public Layer getLayer(String id) {
        for (Layer layer : this._layers) {
            if (!layer.getId().equals(id)) continue;
            return layer;
        }
        return null;
    }

    @Override
    public Layer getParentLayer(Layer layer) {
        String parentId = layer.getParentId();
        return parentId != null ? this.getLayer(parentId) : null;
    }

    @Override
    public void setParentLayer(Layer layer, Layer parent) {
        layer.setParentId(parent != null ? parent.getId() : null);
    }

    @Override
    public void afterDecode(Project p) throws ProjectDecodeException {
        for (Layer layer : this._layers) {
            layer.afterDecode(p, this);
        }
    }

    @Override
    public void prepareExpression(ExpressionScope scope) {
        scope.putExpressionElement("thisComp", this);
        for (Layer layer : this._layers) {
            layer.prepareExpression(scope.clone());
        }
    }

    @Override
    public VideoBuffer renderVideoFrame() {
        this._context.setComposition(this);
        ColorMode colorMode = this.getColorMode();
        this._context.setColorMode(colorMode);
        Time time = this._context.getTime();
        if (this.isFrameDurationPreserved()) {
            Time frameDuration = this.getFrameDuration();
            time = Time.fromFrameNumber((long)time.toFrameNumber(frameDuration), (Time)frameDuration);
            this._context.setTime(time);
            this._context.setVideoFrameDuration(frameDuration);
        }
        CameraLayer cameraLayer = null;
        ListIterator<Layer> it = this._layers.listIterator(this._layers.size());
        while (it.hasPrevious()) {
            Layer layer = it.previous();
            if (!(layer instanceof CameraLayer) || !LayerNature.isVideoEnabled(layer) || layer.getInPoint().after(time) || !layer.getOutPoint().after(time)) continue;
            cameraLayer = (CameraLayer)layer;
            break;
        }
        Size2i renderSize = this._context.getVideoResolution().scale(this.getSize());
        final CameraImpl camera = new CameraImpl(this._context, this._vrSupport, cameraLayer, this.getSize(), renderSize);
        final VideoLayerComposerImpl composer = new VideoLayerComposerImpl(this._context, this._vrSupport, colorMode, renderSize, camera.getPosition());
        final MotionBlur motionBlur = this._motionBlurEnabled ? this._motionBlur : null;
        int i = 0;
        int n = this._layers.size();
        while (i < n) {
            Layer layer = this._layers.get(i);
            if (LayerNature.isVideoEnabled(layer) && !layer.getInPoint().after(time) && layer.getOutPoint().after(time) && layer instanceof MediaLayer) {
                Layer matteLayer;
                final MediaLayer ml = (MediaLayer)layer;
                if (ml.getTrackMatte() != TrackMatte.NONE && i + 1 < n && (matteLayer = this._layers.get(i + 1)) instanceof MediaLayer) {
                    this.setupTrackMatteRenderer(ml, (MediaLayer)matteLayer, composer, camera, null, motionBlur);
                } else {
                    this._context.saveAndExecute(new WrappedOperation<Object>(){

                        @Override
                        public Object execute() {
                            ml.setupVideoRenderer(composer, camera, null, motionBlur, LayerCompositionImpl.this._frameBlendEnabled, true, true);
                            return null;
                        }
                    });
                }
            }
            ++i;
        }
        return composer.compose();
    }

    @Override
    public void setupCollapseTransformation(final VideoLayerComposer composer, final Camera camera, final CollapseTransformation ct, final MotionBlur motionBlur) {
        this._context.setComposition(this);
        Time time = this._context.getTime();
        int i = 0;
        int n = this._layers.size();
        while (i < n) {
            Layer layer = this._layers.get(i);
            if (LayerNature.isVideoEnabled(layer) && !layer.getInPoint().after(time) && layer.getOutPoint().after(time) && layer instanceof MediaLayer) {
                Layer matteLayer;
                final MediaLayer ml = (MediaLayer)layer;
                if (ml.getTrackMatte() != TrackMatte.NONE && i + 1 < n && (matteLayer = this._layers.get(i + 1)) instanceof MediaLayer) {
                    this.setupTrackMatteRenderer(ml, (MediaLayer)matteLayer, composer, camera, ct, motionBlur);
                } else {
                    this._context.saveAndExecute(new WrappedOperation<Object>(){

                        @Override
                        public Object execute() {
                            ml.setupVideoRenderer(composer, camera, ct, motionBlur, LayerCompositionImpl.this._frameBlendEnabled, true, true);
                            return null;
                        }
                    });
                }
            }
            ++i;
        }
    }

    private void setupTrackMatteRenderer(final MediaLayer fillLayer, final MediaLayer matteLayer, VideoLayerComposer composer, final Camera camera, final CollapseTransformation ct, final MotionBlur motionBlur) {
        final VideoLayerRenderer[] renderers = new VideoLayerRenderer[2];
        final Vec3d[][] vertices = new Vec3d[1][];
        final String[] intersectionGroup = new String[1];
        this._context.saveAndExecute(new WrappedOperation<Object>(){

            @Override
            public Object execute() {
                fillLayer.setupVideoRenderer(new VideoLayerComposer(){

                    public void add2D(VideoLayerRenderer r) {
                        renderers[0] = r;
                    }

                    public void add3D(VideoLayerRenderer r, Vec3d[] v, String ig) {
                        renderers[0] = r;
                        vertices[0] = v;
                        intersectionGroup[0] = ig;
                    }
                }, camera, ct, motionBlur, LayerCompositionImpl.this._frameBlendEnabled, true, true);
                return null;
            }
        });
        this._context.saveAndExecute(new WrappedOperation<Object>(){

            @Override
            public Object execute() {
                matteLayer.setupVideoRenderer(new VideoLayerComposer(){

                    public void add2D(VideoLayerRenderer r) {
                        renderers[1] = r;
                    }

                    public void add3D(VideoLayerRenderer r, Vec3d[] v, String ig) {
                        renderers[1] = r;
                    }
                }, camera, ct, motionBlur, LayerCompositionImpl.this._frameBlendEnabled, true, true);
                return null;
            }
        });
        if (renderers[0] == null) {
            return;
        }
        if (renderers[1] == null) {
            if (vertices[0] == null) {
                composer.add2D(renderers[0]);
            } else {
                composer.add3D(renderers[0], vertices[0], intersectionGroup[0]);
            }
            return;
        }
        final TrackMatte trackMatte = fillLayer.getTrackMatte();
        VideoLayerRenderer r = new VideoLayerRenderer(){

            public VideoLayerBuffer render(boolean withDepthBuffer) {
                VideoLayerBuffer fillBuffer = null;
                VideoLayerBuffer matteBuffer = null;
                VideoBuffer vbFill = null;
                try {
                    fillBuffer = renderers[0].render(withDepthBuffer);
                    matteBuffer = renderers[1].render(false);
                    vbFill = fillBuffer.getVideoBuffer();
                    VideoBuffer resultBuffer = LayerCompositionImpl.this._vrSupport.createVideoBuffer(vbFill.getColorMode(), vbFill.getBounds());
                    LayerCompositionImpl.this._vrSupport.trackMatte(matteBuffer.getVideoBuffer(), fillBuffer.getVideoBuffer(), resultBuffer, trackMatte, matteBuffer.getOpacity());
                    VideoLayerBufferImpl newBuffer = new VideoLayerBufferImpl(resultBuffer, fillBuffer.getDepthBuffer(), fillBuffer.getBlendMode(), fillBuffer.getOpacity(), fillBuffer.getDissolveSeed());
                    fillBuffer = null;
                    VideoLayerBufferImpl videoLayerBufferImpl = newBuffer;
                    return videoLayerBufferImpl;
                }
                finally {
                    if (matteBuffer != null) {
                        matteBuffer.dispose();
                    }
                    if (fillBuffer != null) {
                        fillBuffer.dispose();
                    } else if (vbFill != null) {
                        vbFill.dispose();
                    }
                }
            }
        };
        if (vertices[0] == null) {
            composer.add2D(r);
        } else {
            composer.add3D(r, vertices[0], intersectionGroup[0]);
        }
    }

    @Override
    public VideoBuffer getLayerVideoFrame(Layer layer, final boolean withEffects, final boolean withTransformation) {
        if (this._context.getComposition() != this) {
            throw new IllegalStateException("this composition is not the context composition.");
        }
        if (layer == null) {
            throw new NullPointerException();
        }
        if (!this._layers.contains(layer)) {
            throw new IllegalArgumentException("no such layer found in this LayerComposition");
        }
        if (!LayerNature.isVideoNature(layer)) {
            return null;
        }
        if (layer instanceof MediaLayer) {
            final MediaLayer ml = (MediaLayer)layer;
            MediaInput input = ml.getMediaInput();
            if (input == null) {
                return null;
            }
            VideoBounds bounds = input.getVideoFrameBounds();
            Size2i layerSize = LayerNature.isCTCR(layer) ? this.getSize() : new Size2i(bounds.width, bounds.height);
            Size2i viewportSize = this._context.getVideoResolution().scale(layerSize);
            if (viewportSize.width == 0 || viewportSize.height == 0) {
                VideoBuffer vb = this._vrSupport.createVideoBuffer(this._context.getColorMode(), viewportSize);
                vb.clear();
                return vb;
            }
            final VideoLayerRenderer[] renderers = new VideoLayerRenderer[1];
            final VideoLayerComposer composer = new VideoLayerComposer(){

                public void add2D(VideoLayerRenderer r) {
                    renderers[0] = r;
                }

                public void add3D(VideoLayerRenderer r, Vec3d[] v, String ig) {
                    renderers[0] = r;
                }
            };
            final CameraImpl camera = new CameraImpl(this._context, this._vrSupport, null, layerSize, viewportSize);
            final MotionBlur motionBlur = this._motionBlurEnabled ? this._motionBlur : null;
            this._context.saveAndExecute(new WrappedOperation<Object>(){

                @Override
                public Object execute() {
                    ml.setupVideoRenderer(composer, camera, null, motionBlur, LayerCompositionImpl.this._frameBlendEnabled, withEffects, withTransformation);
                    return null;
                }
            });
            VideoLayerBuffer vlb = renderers[0].render(false);
            return vlb.getVideoBuffer();
        }
        return null;
    }

    @Override
    public AudioBuffer renderAudioChunk() {
        this._context.setComposition(this);
        if (this.isFrameDurationPreserved()) {
            this._context.setVideoFrameDuration(this.getFrameDuration());
        }
        AudioBuffer ab = null;
        Time time = this._context.getTime();
        Time chunkDuration = Time.fromFrameNumber((long)this._context.getAudioFrameCount(), (Time)this._context.getAudioMode().sampleDuration);
        for (Layer layer : this._layers) {
            MediaLayer al;
            AudioBuffer alab;
            if (!LayerNature.isAudioEnabled(layer) || layer.getInPoint().after(time.add(chunkDuration)) || !layer.getOutPoint().after(time) || !(layer instanceof MediaLayer) || (alab = this._context.saveAndExecute(new WrappedOperation<AudioBuffer>(al = (MediaLayer)layer){
                private final /* synthetic */ MediaLayer val$al;
                {
                    this.val$al = mediaLayer;
                }

                @Override
                public AudioBuffer execute() {
                    return this.val$al.renderAudioChunk(true, true);
                }
            })) == null) continue;
            if (ab == null) {
                ab = alab;
                continue;
            }
            AudioBuffer abOld = ab;
            try {
                ab = this._arSupport.mix(ab, alab);
            }
            finally {
                if (ab != abOld) {
                    abOld.dispose();
                }
                if (ab != alab) {
                    alab.dispose();
                }
            }
        }
        return ab;
    }

    @Override
    public AudioBuffer getLayerAudioChunk(Layer layer, final boolean withEffects, final boolean withLevelsAndInOut) {
        if (this._context.getComposition() != this) {
            throw new IllegalStateException("this composition is not the context composition.");
        }
        if (layer == null) {
            throw new NullPointerException();
        }
        if (!this._layers.contains(layer)) {
            throw new IllegalArgumentException("no such layer found in this LayerComposition");
        }
        if (!LayerNature.isAudioNature(layer)) {
            return null;
        }
        if (layer instanceof MediaLayer) {
            final MediaLayer ml = (MediaLayer)layer;
            MediaInput input = ml.getMediaInput();
            if (input == null) {
                return null;
            }
            return this._context.saveAndExecute(new WrappedOperation<AudioBuffer>(){

                @Override
                public AudioBuffer execute() {
                    return ml.renderAudioChunk(withEffects, withLevelsAndInOut);
                }
            });
        }
        return null;
    }

    @Override
    public Object createExpressionElement(CoreContext context) {
        return new LayerCompositionExpressionElement(context);
    }

    public class LayerCompositionExpressionElement {
        protected final CoreContext context;

        public LayerCompositionExpressionElement(CoreContext context) {
            this.context = context;
        }

        public Object layer(int index) {
            Layer layer = (Layer)LayerCompositionImpl.this._layers.get(LayerCompositionImpl.this._layers.size() - index);
            return this.context.getExpressionElement(layer);
        }

        public Object layer(String name) {
            ListIterator it = LayerCompositionImpl.this._layers.listIterator(LayerCompositionImpl.this._layers.size());
            while (it.hasPrevious()) {
                Layer layer = (Layer)it.previous();
                if (!layer.getName().equals(name)) continue;
                return this.context.getExpressionElement(layer);
            }
            return null;
        }

        public int getHeight() {
            return LayerCompositionImpl.this.getSize().width;
        }

        public int getWidth() {
            return LayerCompositionImpl.this.getSize().height;
        }
    }
}

