/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal;

import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.core.AbstractItem;
import ch.kuramo.javie.core.FileItem;
import ch.kuramo.javie.core.MediaFileInput;
import ch.kuramo.javie.core.MediaInput;
import ch.kuramo.javie.core.MediaInputPlaceholder;
import ch.kuramo.javie.core.MediaItem;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.ProjectDecodeException;
import ch.kuramo.javie.core.annotations.ProjectElement;
import ch.kuramo.javie.core.internal.MediaInputPlaceholderImpl;
import ch.kuramo.javie.core.services.MediaFileInputFactory;
import com.google.inject.Inject;
import com.google.inject.Injector;
import java.io.File;
import net.arnx.jsonic.JSONHint;

@ProjectElement(value="mediaFile")
public class MediaFileItem
extends AbstractItem
implements MediaItem,
FileItem {
    private File _file;
    private VideoBounds _videoFrameBounds;
    private MediaInput _mediaInput;
    @Inject
    private MediaFileInputFactory _mediaFileInputFactory;
    @Inject
    private Injector _injector;

    public void initialize(File file) {
        super.initialize();
        MediaFileInput input = this._mediaFileInputFactory.get(this.getId(), file);
        if (input != null) {
            this._file = file;
            this._videoFrameBounds = input.isVideoAvailable() ? input.getVideoFrameBounds() : null;
            this._mediaInput = input;
            this.setName(this._file.getName());
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    public void dispose() {
        if (this._mediaInput != null) {
            if (!(this._mediaInput instanceof MediaInputPlaceholder)) {
                this._mediaFileInputFactory.release(this.getId());
            }
            this._mediaInput = null;
        }
    }

    public File getFile() {
        return this._file;
    }

    public void setFile(File file) {
        this._file = file;
    }

    public VideoBounds getVideoFrameBounds() {
        return this._videoFrameBounds;
    }

    public void setVideoFrameBounds(VideoBounds videoFrameBounds) {
        this._videoFrameBounds = videoFrameBounds;
    }

    @JSONHint(ignore=true)
    public MediaInput getMediaInput() {
        return this._mediaInput;
    }

    public void afterDecode(Project p) throws ProjectDecodeException {
        super.afterDecode(p);
        MediaFileInput input = this._mediaFileInputFactory.get(this.getId(), this._file);
        if (input != null) {
            this._videoFrameBounds = input.isVideoAvailable() ? input.getVideoFrameBounds() : null;
            this._mediaInput = input;
        } else {
            MediaInputPlaceholderImpl placeholder = (MediaInputPlaceholderImpl)this._injector.getInstance(MediaInputPlaceholderImpl.class);
            placeholder.setVideoFrameBounds(this._videoFrameBounds);
            this._mediaInput = placeholder;
        }
    }

    @JSONHint(ignore=true)
    public String getKind() {
        return null;
    }
}

