/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal;

import ch.kuramo.javie.api.Color;
import ch.kuramo.javie.api.ColorMode;
import ch.kuramo.javie.api.Size2i;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.core.AbstractItem;
import ch.kuramo.javie.core.AudioBuffer;
import ch.kuramo.javie.core.MediaInput;
import ch.kuramo.javie.core.SolidColorItem;
import ch.kuramo.javie.core.VectorMediaInput;
import ch.kuramo.javie.core.VideoBuffer;
import ch.kuramo.javie.core.annotations.ProjectElement;
import ch.kuramo.javie.core.services.RenderContext;
import ch.kuramo.javie.core.services.VideoRenderSupport;
import com.google.inject.Inject;
import net.arnx.jsonic.JSONHint;

@ProjectElement(value="solidColor")
public class SolidColorItemImpl
extends AbstractItem
implements SolidColorItem {
    private Color _color;
    private Size2i _size;
    private VideoBounds _bounds;
    private final SolidColorInput _input = new SolidColorInput();
    @Inject
    private RenderContext _context;
    @Inject
    private VideoRenderSupport _vrSupport;

    public void initialize(Color color, Size2i size) {
        super.initialize();
        this.setColor(color);
        this.setSize(size);
    }

    public void dispose() {
    }

    public Color getColor() {
        return this._color;
    }

    public void setColor(Color color) {
        this._color = color;
    }

    public Size2i getSize() {
        return this._size;
    }

    public void setSize(Size2i size) {
        this._size = size;
        this._bounds = new VideoBounds(size.width, size.height);
    }

    @JSONHint(ignore=true)
    public MediaInput getMediaInput() {
        return this._input;
    }

    @JSONHint(ignore=true)
    public String getKind() {
        return "\u5e73\u9762";
    }

    public String toString() {
        return "color:" + this._color + " size:" + this._size;
    }

    private class SolidColorInput
    implements VectorMediaInput {
        private SolidColorInput() {
        }

        public void dispose() {
        }

        public boolean isVideoAvailable() {
            return true;
        }

        public boolean isAudioAvailable() {
            return false;
        }

        public Time getDuration() {
            return null;
        }

        public Time getVideoFrameDuration() {
            return null;
        }

        public VideoBounds getVideoFrameBounds() {
            return SolidColorItemImpl.this._bounds;
        }

        public VideoBuffer getVideoFrame(Time mediaTime) {
            ColorMode colorMode = SolidColorItemImpl.this._context.getColorMode();
            Size2i size = SolidColorItemImpl.this._context.getVideoResolution().scale(SolidColorItemImpl.this._size);
            VideoBuffer vb = SolidColorItemImpl.this._vrSupport.createVideoBuffer(colorMode, size);
            vb.allocateAsTexture();
            SolidColorItemImpl.this._vrSupport.fill(vb, SolidColorItemImpl.this._color);
            return vb;
        }

        public void rasterize(VideoBuffer resultBuffer, double[] mvMatrix, double[] prjMatrix, Time mediaTime) {
            Size2i size = SolidColorItemImpl.this._context.getVideoResolution().scale(SolidColorItemImpl.this._size);
            SolidColorItemImpl.this._vrSupport.fillRectCR(resultBuffer, mvMatrix, prjMatrix, size, SolidColorItemImpl.this._color);
        }

        public AudioBuffer getAudioChunk(Time mediaTime) {
            throw new UnsupportedOperationException("audio is not available");
        }
    }
}

