/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal;

import ch.kuramo.javie.api.ColorMode;
import ch.kuramo.javie.api.Size2i;
import ch.kuramo.javie.api.Vec3d;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.VideoBuffer;
import ch.kuramo.javie.core.VideoLayerBuffer;
import ch.kuramo.javie.core.VideoLayerComposer;
import ch.kuramo.javie.core.VideoLayerRenderer;
import ch.kuramo.javie.core.WrappedOperation;
import ch.kuramo.javie.core.services.RenderContext;
import ch.kuramo.javie.core.services.VideoRenderSupport;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.vecmath.Vector3d;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class VideoLayerComposerImpl
implements VideoLayerComposer {
    private final Comparator<Entry> _entryComparator = new Comparator<Entry>(){

        private int signum(Vec3d pt, Entry e) {
            return (int)Math.signum(e.normalVec.x * (pt.x - e.vertices[0].x) + e.normalVec.y * (pt.y - e.vertices[0].y) + e.normalVec.z * (pt.z - e.vertices[0].z));
        }

        private int sameSideVertices(Entry o1, Entry o2) {
            int plus = 0;
            int minus = 0;
            int i = 1;
            while (i < 5) {
                switch (this.signum(o1.vertices[i], o2)) {
                    case 1: {
                        ++plus;
                        break;
                    }
                    case -1: {
                        --minus;
                    }
                }
                ++i;
            }
            return plus > -minus ? plus : minus;
        }

        @Override
        public int compare(Entry o1, Entry o2) {
            int ssv1 = this.sameSideVertices(o1, o2);
            if (Math.abs(ssv1) == 4) {
                return Math.signum(ssv1) == (float)this.signum(VideoLayerComposerImpl.this._cameraPosition, o2) ? 1 : -1;
            }
            int ssv2 = this.sameSideVertices(o2, o1);
            if (Math.abs(ssv2) == 4) {
                return Math.signum(ssv2) == (float)this.signum(VideoLayerComposerImpl.this._cameraPosition, o1) ? -1 : 1;
            }
            return (int)Math.signum(o2.vertices[0].z - o1.vertices[0].z);
        }
    };
    private final RenderContext _context;
    private final VideoRenderSupport _vrSupport;
    private final ColorMode _colorMode;
    private final Size2i _renderSize;
    private final Vec3d _cameraPosition;
    private final List<Section> _sections = Util.newList();
    private Section _currentSection;

    VideoLayerComposerImpl(RenderContext context, VideoRenderSupport vrSupport, ColorMode colorMode, Size2i renderSize, Vec3d cameraPosition) {
        this._context = context;
        this._vrSupport = vrSupport;
        this._colorMode = colorMode;
        this._renderSize = renderSize;
        this._cameraPosition = cameraPosition;
    }

    @Override
    public void add2D(VideoLayerRenderer renderer) {
        this._currentSection = null;
        this._sections.add(new Section(new Entry(renderer)));
    }

    @Override
    public void add3D(VideoLayerRenderer renderer, Vec3d[] vertices, String intersectionGroup) {
        if (vertices.length != 5) {
            throw new IllegalArgumentException("vertices length must be 5: length=" + vertices.length);
        }
        if (this._currentSection == null) {
            this._currentSection = new Section();
            this._sections.add(this._currentSection);
        }
        this._currentSection.add(new Entry(renderer, vertices, intersectionGroup));
    }

    VideoBuffer compose() {
        VideoBuffer vb = this._vrSupport.createVideoBuffer(this._colorMode, this._renderSize);
        vb.allocateAsTexture();
        vb.clear();
        List<Entry> entries = Util.newList();
        for (Section s : this._sections) {
            Collections.sort(s.entries, this._entryComparator);
            entries.addAll(s.entries);
        }
        for (final Entry e : entries) {
            VideoLayerBuffer vlb = this._context.saveAndExecute(new WrappedOperation<VideoLayerBuffer>(){

                @Override
                public VideoLayerBuffer execute() {
                    return e.renderer.render(!e.intersectionMembers.isEmpty());
                }
            });
            if (!e.intersectionMembers.isEmpty()) {
                List<VideoLayerBuffer> intersectionGroupBuffers = Util.newList();
                intersectionGroupBuffers.add(vlb);
                for (final Entry ee : e.intersectionMembers) {
                    vlb = this._context.saveAndExecute(new WrappedOperation<VideoLayerBuffer>(){

                        @Override
                        public VideoLayerBuffer execute() {
                            return ee.renderer.render(true);
                        }
                    });
                    intersectionGroupBuffers.add(vlb);
                }
                vb = this.blend(intersectionGroupBuffers, vb);
                continue;
            }
            vb = this.blend(Collections.singleton(vlb), vb);
        }
        return vb;
    }

    private VideoBuffer blend(Collection<VideoLayerBuffer> intersectionGroupBuffers, VideoBuffer vb) {
        VideoBuffer vbNew = this._vrSupport.createVideoBuffer(this._colorMode, this._renderSize);
        vbNew.allocateAsTexture();
        vbNew.clear();
        if (intersectionGroupBuffers.size() == 1) {
            VideoLayerBuffer vlb = intersectionGroupBuffers.iterator().next();
            this._vrSupport.blend(vlb.getVideoBuffer(), vb, vbNew, vlb.getBlendMode(), vlb.getOpacity(), vlb.getDissolveSeed());
        } else {
            this._vrSupport.blend(intersectionGroupBuffers, vb, vbNew);
        }
        for (VideoLayerBuffer vlb : intersectionGroupBuffers) {
            vlb.dispose();
        }
        vb.dispose();
        return vbNew;
    }

    private static class Entry {
        final VideoLayerRenderer renderer;
        final Vec3d[] vertices;
        final Vec3d normalVec;
        final String intersectionGroup;
        final Set<Entry> intersectionMembers = Util.newSet();

        Entry(VideoLayerRenderer renderer, Vec3d[] vertices, String intersectionGroup) {
            this.renderer = renderer;
            this.vertices = vertices;
            this.intersectionGroup = intersectionGroup;
            Vector3d nv = new Vector3d();
            nv.cross(new Vector3d(vertices[0].x - vertices[1].x, vertices[0].y - vertices[1].y, vertices[0].z - vertices[1].z), new Vector3d(vertices[0].x - vertices[2].x, vertices[0].y - vertices[2].y, vertices[0].z - vertices[2].z));
            this.normalVec = new Vec3d(nv.x, nv.y, nv.z);
        }

        Entry(VideoLayerRenderer renderer) {
            this.renderer = renderer;
            this.vertices = null;
            this.normalVec = null;
            this.intersectionGroup = "";
        }
    }

    private static class Section {
        final List<Entry> entries = Util.newList();
        final Map<String, Entry> intersectionGroupMap = Util.newMap();

        Section() {
        }

        Section(Entry e) {
            this.add(e);
        }

        void add(Entry e) {
            if (e.intersectionGroup.length() == 0) {
                this.entries.add(e);
                return;
            }
            Entry ee = this.intersectionGroupMap.get(e.intersectionGroup);
            if (ee != null) {
                ee.intersectionMembers.add(e);
            } else {
                this.entries.add(e);
                this.intersectionGroupMap.put(e.intersectionGroup, e);
            }
        }
    }
}

