/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal.services;

import ch.kuramo.javie.api.IArray;
import ch.kuramo.javie.api.IObjectArray;
import ch.kuramo.javie.api.services.IArrayPools;
import ch.kuramo.javie.core.internal.services.ArrayPool;
import java.lang.reflect.Array;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayPoolsImpl
implements IArrayPools {
    private static final Logger _logger = LoggerFactory.getLogger(ArrayPoolsImpl.class);
    private final ArrayPool<byte[]> _bytePool = new ArrayPool(Byte.TYPE);
    private final ArrayPool<short[]> _shortPool = new ArrayPool(Short.TYPE);
    private final ArrayPool<int[]> _intPool = new ArrayPool(Integer.TYPE);
    private final ArrayPool<float[]> _floatPool = new ArrayPool(Float.TYPE);
    private final ArrayPool<double[]> _doublePool = new ArrayPool(Double.TYPE);
    private final ArrayPool<Object[]> _objectPool = new ArrayPool(Object.class);

    public IArray<byte[]> getByteArray(int length) {
        return new ByteArray(length);
    }

    public IArray<short[]> getShortArray(int length) {
        return new ShortArray(length);
    }

    public IArray<int[]> getIntArray(int length) {
        return new IntArray(length);
    }

    public IArray<float[]> getFloatArray(int length) {
        return new FloatArray(length);
    }

    public IArray<double[]> getDoubleArray(int length) {
        return new DoubleArray(length);
    }

    public <T> IObjectArray<T> getObjectArray(int length) {
        return new ObjectArray(length);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class AbstractArray<T>
    implements IArray<T> {
        private final ArrayPool<T> pool;
        protected final int length;
        protected T array;

        protected AbstractArray(ArrayPool<T> pool, int length) {
            this.pool = pool;
            this.length = length;
            this.array = pool.get(length);
        }

        protected void finalize() throws Throwable {
            if (this.array != null) {
                _logger.warn(String.format("ARRAY IS NOT RELEASED: %s[%d/%d]", this.array.getClass().getComponentType().getName(), this.length, Array.getLength(this.array)));
                this.release();
            }
            super.finalize();
        }

        public T getArray() {
            return this.array;
        }

        public int getLength() {
            return this.length;
        }

        public void release() {
            if (this.array != null) {
                this.pool.put(this.array);
                this.array = null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ByteArray
    extends AbstractArray<byte[]> {
        private ByteArray(int length) {
            super(ArrayPoolsImpl.this._bytePool, length);
        }

        public void clear() {
            Arrays.fill((byte[])this.array, 0, this.length, (byte)0);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DoubleArray
    extends AbstractArray<double[]> {
        private DoubleArray(int length) {
            super(ArrayPoolsImpl.this._doublePool, length);
        }

        public void clear() {
            Arrays.fill((double[])this.array, 0, this.length, 0.0);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FloatArray
    extends AbstractArray<float[]> {
        private FloatArray(int length) {
            super(ArrayPoolsImpl.this._floatPool, length);
        }

        public void clear() {
            Arrays.fill((float[])this.array, 0, this.length, 0.0f);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IntArray
    extends AbstractArray<int[]> {
        private IntArray(int length) {
            super(ArrayPoolsImpl.this._intPool, length);
        }

        public void clear() {
            Arrays.fill((int[])this.array, 0, this.length, 0);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ObjectArray<T>
    extends AbstractArray<Object[]>
    implements IObjectArray<T> {
        private ObjectArray(int length) {
            super(ArrayPoolsImpl.this._objectPool, length);
        }

        public void clear() {
            Arrays.fill((Object[])this.array, 0, this.length, null);
        }

        @Override
        public void release() {
            this.clear();
            super.release();
        }

        public T get(int i) {
            return (T)((Object[])this.array)[i];
        }

        public void set(int i, T value) {
            ((Object[])this.array)[i] = value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ShortArray
    extends AbstractArray<short[]> {
        private ShortArray(int length) {
            super(ArrayPoolsImpl.this._shortPool, length);
        }

        public void clear() {
            Arrays.fill((short[])this.array, 0, this.length, (short)0);
        }
    }
}

