/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal.services;

import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IAudioBuffer;
import ch.kuramo.javie.api.IObjectArray;
import ch.kuramo.javie.api.services.IAudioEffectContext;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.internal.services.AbstractEffectContextProxy;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AudioEffectContextProxy
extends AbstractEffectContextProxy<IAudioEffectContext>
implements IAudioEffectContext {
    private static final ThreadLocal<LinkedList<IAudioEffectContext>> _threadLocal = new ThreadLocal();

    static void push(IAudioEffectContext impl) {
        AudioEffectContextProxy.getStack(true).addLast(impl);
    }

    static void pop() {
        LinkedList<IAudioEffectContext> stack = AudioEffectContextProxy.getStack(false);
        stack.removeLast();
        if (stack.isEmpty()) {
            _threadLocal.remove();
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static LinkedList<IAudioEffectContext> getStack(boolean create) {
        void var1_3;
        LinkedList<IAudioEffectContext> linkedList = _threadLocal.get();
        if (linkedList == null) {
            if (!create) throw new IllegalStateException("no stack is found");
            LinkedList linkedList2 = Util.newLinkedList();
            _threadLocal.set(linkedList2);
            return var1_3;
        } else {
            if (!linkedList.isEmpty()) return var1_3;
            throw new IllegalStateException("stack is empty");
        }
    }

    @Override
    protected IAudioEffectContext getImpl() {
        return AudioEffectContextProxy.getStack(false).getLast();
    }

    public <V> IObjectArray<V> values(IAnimatableValue<V> avalue) {
        return this.getImpl().values(avalue);
    }

    public <V> IObjectArray<V> values(IAnimatableValue<V> avalue, int animationRate) {
        return this.getImpl().values(avalue, animationRate);
    }

    public IAudioBuffer doPreviousEffect() {
        return this.getImpl().doPreviousEffect();
    }
}

