/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal.services;

import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IAudioBuffer;
import ch.kuramo.javie.api.IObjectArray;
import ch.kuramo.javie.api.services.IArrayPools;
import ch.kuramo.javie.api.services.IAudioEffectContext;
import ch.kuramo.javie.core.AnimatableValue;
import ch.kuramo.javie.core.AudioBuffer;
import ch.kuramo.javie.core.AudioEffect;
import ch.kuramo.javie.core.Effect;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.WrappedOperation;
import ch.kuramo.javie.core.internal.services.AbstractEffectContext;
import ch.kuramo.javie.core.internal.services.AudioEffectContextProxy;
import ch.kuramo.javie.core.services.AudioEffectPipeline;
import ch.kuramo.javie.core.services.AudioRenderSupport;
import ch.kuramo.javie.core.services.RenderContext;
import ch.kuramo.javie.core.services.VideoRenderSupport;
import com.google.inject.Inject;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AudioEffectPipelineImpl
implements AudioEffectPipeline {
    @Inject
    private RenderContext _context;
    @Inject
    private VideoRenderSupport _vrSupport;
    @Inject
    private AudioRenderSupport _arSupport;
    @Inject
    private IArrayPools _arrayPools;

    @Override
    public AudioBuffer doAudioEffects(List<Effect> effects, WrappedOperation<AudioBuffer> inputOperation) {
        AudioEffectContextImpl impl = new AudioEffectContextImpl(this.enabledAudioEffectsOnly(effects), inputOperation);
        AudioEffectContextProxy.push(impl);
        try {
            AudioBuffer audioBuffer = (AudioBuffer)impl.doPreviousEffect();
            return audioBuffer;
        }
        finally {
            AudioEffectContextProxy.pop();
        }
    }

    private List<AudioEffect> enabledAudioEffectsOnly(List<Effect> effects) {
        List<AudioEffect> audioEffects = Util.newList();
        for (Effect e : effects) {
            if (!(e instanceof AudioEffect) || !e.isEnabled()) continue;
            audioEffects.add((AudioEffect)e);
        }
        return audioEffects;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AudioEffectContextImpl
    extends AbstractEffectContext
    implements IAudioEffectContext {
        private List<AudioEffect> effects;
        private final WrappedOperation<AudioBuffer> inputOperation;

        private AudioEffectContextImpl(List<AudioEffect> effects, WrappedOperation<AudioBuffer> inputOperation) {
            super(AudioEffectPipelineImpl.this._context, AudioEffectPipelineImpl.this._vrSupport, AudioEffectPipelineImpl.this._arSupport);
            this.effects = effects;
            this.inputOperation = inputOperation;
        }

        public <V> IObjectArray<V> values(IAnimatableValue<V> avalue) {
            return this.values(avalue, AudioEffectPipelineImpl.this._context.getAudioAnimationRate());
        }

        public <V> IObjectArray<V> values(IAnimatableValue<V> avalue, int animationRate) {
            AnimatableValue av = (AnimatableValue)avalue;
            animationRate = Math.max(1, Math.min(animationRate, AudioEffectPipelineImpl.this._context.getAudioAnimationRate()));
            IObjectArray objArray = AudioEffectPipelineImpl.this._arrayPools.getObjectArray(AudioEffectPipelineImpl.this._context.getAudioFrameCount());
            av.values(objArray, ((AudioEffectPipelineImpl)AudioEffectPipelineImpl.this)._context.getAudioMode().sampleDuration, animationRate, AudioEffectPipelineImpl.this._context);
            return objArray;
        }

        public IAudioBuffer doPreviousEffect() {
            if (this.effects.isEmpty()) {
                AudioBuffer ab = AudioEffectPipelineImpl.this._context.saveAndExecute(this.inputOperation);
                if (ab == null) {
                    ab = AudioEffectPipelineImpl.this._arSupport.createAudioBuffer();
                    AudioEffectPipelineImpl.this._arSupport.clear(ab);
                }
                return (IAudioBuffer)ab;
            }
            final AudioEffect prevEffect = this.effects.get(this.effects.size() - 1);
            return this.executePrevious(new WrappedOperation<IAudioBuffer>(){

                @Override
                public IAudioBuffer execute() {
                    IAudioBuffer buffer = prevEffect.doAudioEffect();
                    return buffer != null ? buffer : AudioEffectContextImpl.this.doPreviousEffect();
                }
            });
        }

        private <T> T executePrevious(WrappedOperation<T> wop) {
            List<AudioEffect> savedEffects = this.effects;
            try {
                this.effects = this.effects.subList(0, this.effects.size() - 1);
                T t = AudioEffectPipelineImpl.this._context.saveAndExecute(wop);
                return t;
            }
            finally {
                this.effects = savedEffects;
            }
        }
    }
}

