/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal.services;

import ch.kuramo.javie.core.services.RenderBufferPool;
import ch.kuramo.javie.core.services.RenderContext;
import com.google.inject.Inject;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.media.opengl.GL2;

public class RenderBufferPoolImpl
implements RenderBufferPool {
    private final ConcurrentLinkedQueue<Integer> _pool = new ConcurrentLinkedQueue();
    private final RenderContext _context;

    @Inject
    public RenderBufferPoolImpl(RenderContext context) {
        this._context = context;
    }

    private int createRenderBuffer() {
        GL2 gl = this._context.getGL().getGL2();
        int[] rb = new int[1];
        gl.glGenRenderbuffers(1, rb, 0);
        return rb[0];
    }

    private void reduceRenderBuffer(int renderBuffer) {
        GL2 gl = this._context.getGL().getGL2();
        int[] binding = new int[1];
        gl.glGetIntegerv(36007, binding, 0);
        try {
            gl.glBindRenderbuffer(36161, renderBuffer);
            gl.glRenderbufferStorage(36161, 32853, 1, 1);
        }
        finally {
            gl.glBindRenderbuffer(36161, binding[0]);
        }
    }

    public int get() {
        Integer rb = this._pool.peek();
        return rb != null ? rb.intValue() : this.createRenderBuffer();
    }

    public void put(int renderBuffer) {
        this.reduceRenderBuffer(renderBuffer);
        this._pool.offer(renderBuffer);
    }
}

