/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal.services;

import ch.kuramo.javie.api.AudioMode;
import ch.kuramo.javie.api.ColorMode;
import ch.kuramo.javie.api.Resolution;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.core.WrappedOperation;
import ch.kuramo.javie.core.internal.services.AbstractCoreContext;
import ch.kuramo.javie.core.internal.services.AntiAliasSupportProxy;
import ch.kuramo.javie.core.internal.services.FontManagerProxy;
import ch.kuramo.javie.core.services.GLGlobal;
import ch.kuramo.javie.core.services.RenderContext;
import com.google.inject.Inject;
import java.util.concurrent.locks.ReentrantLock;
import javax.media.opengl.GL;
import javax.media.opengl.GL2;
import javax.media.opengl.GLContext;
import javax.media.opengl.glu.GLU;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenderContextImpl
extends AbstractCoreContext
implements RenderContext {
    private static final Logger _logger = LoggerFactory.getLogger(RenderContextImpl.class);
    @Inject
    private GLGlobal _glGlobal;
    @Inject
    private AntiAliasSupportProxy.Lifecycle _aaSupportLifecycle;
    @Inject
    private FontManagerProxy.Lifecycle _fontManagerLifecycle;
    private GLContext _glContext;
    private GLU _glu;
    private int _fboId;
    private Resolution _videoResolution;
    private ColorMode _colorMode;
    private Time _videoFrameDuration;
    private AudioMode _audioMode;
    private int _audioAnimationRate;
    private int _audioFrameCount;

    protected void finalize() throws Throwable {
        if (this._glContext != null) {
            _logger.warn("finalizing a VideoRenderContextImpl object, but the object is not deactivated.");
        }
        super.finalize();
    }

    private void initGL() {
        if (this._glContext != null) {
            return;
        }
        ReentrantLock lock = this._glGlobal.getGlobalLock();
        lock.lock();
        try {
            this._glContext = this._glGlobal.createContext();
            this._glContext.makeCurrent();
        }
        finally {
            lock.unlock();
        }
        GL2 gl = this._glContext.getGL().getGL2();
        this._glu = GLU.createGLU((GL)gl);
        int[] fboId = new int[1];
        gl.glGenFramebuffers(1, fboId, 0);
        this._fboId = fboId[0];
        gl.glBindFramebuffer(36160, this._fboId);
        this._aaSupportLifecycle.createImpl();
        this._fontManagerLifecycle.createImpl();
    }

    @Override
    public void deactivate() {
        if (this._glContext != null) {
            this._fontManagerLifecycle.disposeImpl();
            this._aaSupportLifecycle.disposeImpl();
            GL2 gl = this._glContext.getGL().getGL2();
            gl.glBindFramebuffer(36160, 0);
            gl.glDeleteBuffers(1, new int[]{this._fboId}, 0);
            this._fboId = 0;
            ReentrantLock lock = this._glGlobal.getGlobalLock();
            lock.lock();
            try {
                this._glContext.release();
                this._glGlobal.destroyContext(this._glContext);
            }
            finally {
                lock.unlock();
            }
            this._glContext = null;
            this._glu = null;
        }
        this._videoResolution = null;
        this._colorMode = null;
        this._videoFrameDuration = null;
        this._audioMode = null;
        this._audioAnimationRate = 0;
        this._audioFrameCount = 0;
        super.deactivate();
    }

    @Override
    public void reset() {
        super.reset();
        this._videoResolution = null;
        this._colorMode = null;
        this._videoFrameDuration = null;
        this._audioMode = null;
        this._audioAnimationRate = 0;
        this._audioFrameCount = 0;
    }

    @Override
    public <T> T saveAndExecute(WrappedOperation<T> operation) {
        ColorMode colorMode = this._colorMode;
        Time videoFrameDuration = this._videoFrameDuration;
        int audioFrameCount = this._audioFrameCount;
        try {
            T t = super.saveAndExecute(operation);
            return t;
        }
        finally {
            this._colorMode = colorMode;
            this._videoFrameDuration = videoFrameDuration;
            this._audioFrameCount = audioFrameCount;
        }
    }

    @Override
    public GL getGL() {
        this.initGL();
        return this._glContext.getGL();
    }

    @Override
    public GLU getGLU() {
        this.initGL();
        return this._glu;
    }

    @Override
    public Resolution getVideoResolution() {
        if (this._videoResolution == null) {
            throw new IllegalStateException("videoResolution is not set.");
        }
        return this._videoResolution;
    }

    @Override
    public void setVideoResolution(Resolution resolution) {
        if (this._videoResolution != null) {
            throw new IllegalStateException("videoResolution has already been set.");
        }
        this._videoResolution = resolution;
    }

    @Override
    public ColorMode getColorMode() {
        return this._colorMode;
    }

    @Override
    public void setColorMode(ColorMode colorMode) {
        this._colorMode = colorMode;
    }

    @Override
    public Time getVideoFrameDuration() {
        return this._videoFrameDuration;
    }

    @Override
    public void setVideoFrameDuration(Time frameDuration) {
        this._videoFrameDuration = frameDuration;
    }

    @Override
    public AudioMode getAudioMode() {
        if (this._audioMode == null) {
            throw new IllegalStateException("audioMode is not set.");
        }
        return this._audioMode;
    }

    @Override
    public void setAudioMode(AudioMode audioMode) {
        if (this._audioMode != null) {
            throw new IllegalStateException("audioMode has already been set.");
        }
        this._audioMode = audioMode;
    }

    @Override
    public int getAudioAnimationRate() {
        if (this._audioAnimationRate == 0) {
            throw new IllegalStateException("audioAnimationRate is not set.");
        }
        return this._audioAnimationRate;
    }

    @Override
    public void setAudioAnimationRate(int rate) {
        if (this._audioAnimationRate != 0) {
            throw new IllegalStateException("audioAnimationRate has already been set.");
        }
        if (rate < 1) {
            throw new IllegalArgumentException();
        }
        this._audioAnimationRate = rate;
    }

    @Override
    public int getAudioFrameCount() {
        return this._audioFrameCount;
    }

    @Override
    public void setAudioFrameCount(int count) {
        this._audioFrameCount = count;
    }
}

