/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal.services;

import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.core.Effect;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.VideoBuffer;
import ch.kuramo.javie.core.VideoEffect;
import ch.kuramo.javie.core.WrappedOperation;
import ch.kuramo.javie.core.internal.services.AbstractEffectContext;
import ch.kuramo.javie.core.internal.services.VideoEffectContextProxy;
import ch.kuramo.javie.core.services.AudioRenderSupport;
import ch.kuramo.javie.core.services.RenderContext;
import ch.kuramo.javie.core.services.VideoEffectPipeline;
import ch.kuramo.javie.core.services.VideoRenderSupport;
import com.google.inject.Inject;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VideoEffectPipelineImpl
implements VideoEffectPipeline {
    @Inject
    private RenderContext _context;
    @Inject
    private VideoRenderSupport _vrSupport;
    @Inject
    private AudioRenderSupport _arSupport;

    @Override
    public VideoBounds getVideoBounds(List<Effect> effects, WrappedOperation<VideoBounds> inputBoundsOperation) {
        VideoEffectContextImpl impl = new VideoEffectContextImpl(this.enabledVideoEffectsOnly(effects), inputBoundsOperation, null);
        VideoEffectContextProxy.push(impl);
        try {
            VideoBounds videoBounds = impl.getPreviousBounds();
            return videoBounds;
        }
        finally {
            VideoEffectContextProxy.pop();
        }
    }

    @Override
    public VideoBuffer doVideoEffects(List<Effect> effects, WrappedOperation<VideoBounds> inputBoundsOperation, WrappedOperation<VideoBuffer> inputBufferOperation) {
        VideoEffectContextImpl impl = new VideoEffectContextImpl(this.enabledVideoEffectsOnly(effects), inputBoundsOperation, inputBufferOperation);
        VideoEffectContextProxy.push(impl);
        try {
            VideoBuffer videoBuffer = (VideoBuffer)impl.doPreviousEffect();
            return videoBuffer;
        }
        finally {
            VideoEffectContextProxy.pop();
        }
    }

    private List<VideoEffect> enabledVideoEffectsOnly(List<Effect> effects) {
        List<VideoEffect> videoEffects = Util.newList();
        for (Effect e : effects) {
            if (!(e instanceof VideoEffect) || !e.isEnabled()) continue;
            videoEffects.add((VideoEffect)e);
        }
        return videoEffects;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class VideoEffectContextImpl
    extends AbstractEffectContext
    implements IVideoEffectContext {
        private List<VideoEffect> effects;
        private final WrappedOperation<VideoBounds> inputBoundsOperation;
        private final WrappedOperation<VideoBuffer> inputBufferOperation;
        private boolean gettingBounds;

        private VideoEffectContextImpl(List<VideoEffect> effects, WrappedOperation<VideoBounds> inputBoundsOperation, WrappedOperation<VideoBuffer> inputBufferOperation) {
            super(VideoEffectPipelineImpl.this._context, VideoEffectPipelineImpl.this._vrSupport, VideoEffectPipelineImpl.this._arSupport);
            this.effects = effects;
            this.inputBoundsOperation = inputBoundsOperation;
            this.inputBufferOperation = inputBufferOperation;
        }

        public VideoBounds getPreviousBounds() {
            if (this.inputBoundsOperation == null) {
                throw new IllegalStateException();
            }
            boolean savedGettingBounds = this.gettingBounds;
            try {
                this.gettingBounds = true;
                if (this.effects.isEmpty()) {
                    VideoBounds videoBounds = VideoEffectPipelineImpl.this._context.saveAndExecute(this.inputBoundsOperation);
                    return videoBounds;
                }
                final VideoEffect prevEffect = this.effects.get(this.effects.size() - 1);
                VideoBounds videoBounds = this.executePrevious(new WrappedOperation<VideoBounds>(){

                    @Override
                    public VideoBounds execute() {
                        VideoBounds bounds = prevEffect.getVideoBounds();
                        return bounds != null ? bounds : VideoEffectContextImpl.this.getPreviousBounds();
                    }
                });
                return videoBounds;
            }
            finally {
                this.gettingBounds = savedGettingBounds;
            }
        }

        public IVideoBuffer doPreviousEffect() {
            if (this.inputBufferOperation == null || this.gettingBounds) {
                throw new IllegalStateException();
            }
            if (this.effects.isEmpty()) {
                return (IVideoBuffer)VideoEffectPipelineImpl.this._context.saveAndExecute(this.inputBufferOperation);
            }
            final VideoEffect prevEffect = this.effects.get(this.effects.size() - 1);
            return this.executePrevious(new WrappedOperation<IVideoBuffer>(){

                @Override
                public IVideoBuffer execute() {
                    IVideoBuffer buffer = prevEffect.doVideoEffect();
                    return buffer != null ? buffer : VideoEffectContextImpl.this.doPreviousEffect();
                }
            });
        }

        private <T> T executePrevious(final WrappedOperation<T> wop) {
            List<VideoEffect> savedEffects = this.effects;
            try {
                this.effects = this.effects.subList(0, this.effects.size() - 1);
                Object t = VideoEffectPipelineImpl.this._context.saveAndExecute(new WrappedOperation<T>(){

                    @Override
                    public T execute() {
                        return VideoEffectPipelineImpl.this._vrSupport.pushMatrixAndExecute(wop);
                    }
                });
                return t;
            }
            finally {
                this.effects = savedEffects;
            }
        }
    }
}

