/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.output;

import ch.kuramo.javie.api.AudioMode;
import ch.kuramo.javie.api.Size2i;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.core.AudioBuffer;
import ch.kuramo.javie.core.Composition;
import ch.kuramo.javie.core.VideoBuffer;
import ch.kuramo.javie.core.output.PullSourceOutput;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MacOSXQTMovieOutput
extends PullSourceOutput {
    private static final Logger _logger = LoggerFactory.getLogger(MacOSXQTMovieOutput.class);
    private byte[] _settings;

    static {
        System.loadLibrary("QTMovieOutput");
    }

    public byte[] getSettings() {
        return this._settings;
    }

    public void setSettings(byte[] settings) {
        this._settings = settings;
    }

    protected void doOutput(Composition comp, AudioMode audioMode, File file) {
        int error;
        if (this._settings == null) {
            throw new IllegalStateException("settings is not set");
        }
        Size2i size = comp.getSize();
        Time frameDuration = comp.getFrameDuration();
        Time duration = comp.getDuration();
        if (duration.timeScale != frameDuration.timeScale) {
            duration = Time.fromFrameNumber((long)duration.toFrameNumber(frameDuration), (Time)frameDuration);
        }
        if ((error = this.doOutput(this._settings, file.getAbsolutePath(), size.width, size.height, frameDuration.timeScale, frameDuration.timeValue, duration.timeValue, audioMode.channels, audioMode.sampleRate, audioMode.sampleSize, audioMode.dataType == AudioMode.DataType.FLOAT, duration.toFrameNumber(audioMode.sampleDuration))) != 0 && error != -128) {
            _logger.error("doOutput: error=" + error);
        }
    }

    protected void finishVideoRequest(PullSourceOutput.VideoRequest request, VideoBuffer vb) {
        this.copyVideoBufferToByteBuffer(vb, ((VideoRequestWithByteBuffer)request).byteBuffer);
    }

    protected void finishAudioRequest(PullSourceOutput.AudioRequest request, AudioBuffer ab) {
        this.copyAudioBufferToByteBuffer(ab, ((AudioRequestWithByteBuffer)request).byteBuffer);
    }

    protected void copyVideoBufferToByteBuffer(VideoBuffer vb, ByteBuffer bb) {
        Object array = vb.getArray();
        bb.order(ByteOrder.nativeOrder());
        if (array instanceof byte[]) {
            bb.put((byte[])array, 0, bb.capacity());
        } else if (array instanceof short[]) {
            bb.asShortBuffer().put((short[])array, 0, bb.capacity() / 2);
        } else if (array instanceof float[]) {
            bb.asFloatBuffer().put((float[])array, 0, bb.capacity() / 4);
        } else {
            throw new IllegalArgumentException("not array or unsupported array type: " + array.getClass().getName());
        }
        bb.position(bb.capacity());
    }

    protected void copyAudioBufferToByteBuffer(AudioBuffer ab, ByteBuffer bb) {
        bb.order(ByteOrder.nativeOrder());
        switch (ab.getAudioMode().dataType) {
            case SHORT: {
                bb.asShortBuffer().put((short[])ab.getData(), 0, ab.getDataLength());
                break;
            }
            case INT: {
                bb.asIntBuffer().put((int[])ab.getData(), 0, ab.getDataLength());
                break;
            }
            case FLOAT: {
                bb.asFloatBuffer().put((float[])ab.getData(), 0, ab.getDataLength());
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported AudioMode: " + ab.getAudioMode());
            }
        }
        bb.position(ab.getDataLengthInBytes());
    }

    private int videoRequest(long timeValue, int timeScale, ByteBuffer buffer) {
        try {
            buffer.clear();
            this.postVideoRequest(new VideoRequestWithByteBuffer(new Time(timeValue, timeScale), buffer));
            return buffer.position();
        }
        catch (InterruptedException e) {
            _logger.warn("unexpected interruption", (Throwable)e);
            return -1;
        }
    }

    private int audioRequest(long timeValue, int timeScale, ByteBuffer buffer) {
        int frameCount = timeScale;
        try {
            buffer.clear();
            this.postAudioRequest(new AudioRequestWithByteBuffer(new Time(timeValue, timeScale), frameCount, buffer));
            return buffer.position();
        }
        catch (InterruptedException e) {
            _logger.warn("unexpected interruption", (Throwable)e);
            return -1;
        }
    }

    private boolean updateProgress(short message, int percentDone) {
        if (this.isCanceled()) {
            return false;
        }
        switch (message) {
            case 0: {
                this.beginTask(65536);
                break;
            }
            case 1: {
                this.currentWork(percentDone);
                break;
            }
            case 2: {
                this.done();
            }
        }
        return true;
    }

    public static byte[] doUserDialogAndGetSettings(byte[] defaultSettings) {
        byte[][] ioSettings = new byte[][]{defaultSettings};
        int error = MacOSXQTMovieOutput.doUserDialogAndGetSettings(ioSettings);
        switch (error) {
            case 0: {
                return ioSettings[0];
            }
            case -128: {
                return null;
            }
        }
        _logger.error("doUserDialogAndGetSettings: error=" + error);
        return null;
    }

    private static native int doUserDialogAndGetSettings(byte[][] var0);

    private native int doOutput(byte[] var1, String var2, int var3, int var4, int var5, long var6, long var8, int var10, int var11, int var12, boolean var13, long var14);

    private class AudioRequestWithByteBuffer
    extends PullSourceOutput.AudioRequest {
        private final ByteBuffer byteBuffer;

        private AudioRequestWithByteBuffer(Time time, int frameCount, ByteBuffer byteBuffer) {
            super(time, frameCount);
            this.byteBuffer = byteBuffer;
        }
    }

    private class VideoRequestWithByteBuffer
    extends PullSourceOutput.VideoRequest {
        private final ByteBuffer byteBuffer;

        private VideoRequestWithByteBuffer(Time time, ByteBuffer byteBuffer) {
            super(time);
            this.byteBuffer = byteBuffer;
        }
    }
}

