/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.output;

import ch.kuramo.javie.api.AudioMode;
import ch.kuramo.javie.api.Resolution;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.core.AudioBuffer;
import ch.kuramo.javie.core.Composition;
import ch.kuramo.javie.core.VideoBuffer;
import ch.kuramo.javie.core.misc.AtiIntelLock;
import ch.kuramo.javie.core.output.ProgressMonitor;
import ch.kuramo.javie.core.services.AudioRenderSupport;
import ch.kuramo.javie.core.services.GLGlobal;
import ch.kuramo.javie.core.services.RenderContext;
import ch.kuramo.javie.core.services.VideoRenderSupport;
import com.google.inject.Inject;
import java.io.File;
import java.util.Arrays;

public abstract class PushSourceOutput {
    @Inject
    private RenderContext _context;
    @Inject
    private VideoRenderSupport _vrSupport;
    @Inject
    private AudioRenderSupport _arSupport;
    @Inject
    private GLGlobal _glGlobal;

    public void doOutput(final Composition comp, final AudioMode audioMode, File file, ProgressMonitor progMon) {
        ProgressMonitor monitor;
        this.initialize(comp, audioMode, file);
        ProgressMonitor progressMonitor = monitor = progMon != null ? progMon : ProgressMonitor.NULL;
        if (this.isVideoOutputting()) {
            Thread audioThread = null;
            if (this.isAudioOutputting()) {
                final ProgressMonitor audioMon = new ProgressMonitor(){

                    public void beginTask(int totalWork) {
                    }

                    public void currentWork(int currentWork) {
                    }

                    public void done() {
                    }

                    public boolean isCanceled() {
                        return monitor.isCanceled();
                    }
                };
                audioThread = new Thread(){

                    public void run() {
                        PushSourceOutput.this.audioLoop(comp, audioMode, audioMon);
                    }
                };
                audioThread.start();
            }
            try {
                this.videoLoop(comp, audioMode, monitor);
            }
            catch (Throwable throwable) {
                if (audioThread != null) {
                    try {
                        audioThread.join();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.finish();
                throw throwable;
            }
            if (audioThread != null) {
                try {
                    audioThread.join();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.finish();
        } else if (this.isAudioOutputting()) {
            try {
                this.audioLoop(comp, audioMode, monitor);
            }
            finally {
                this.finish();
            }
        } else {
            throw new IllegalStateException("neither video nor audio is outputting.");
        }
    }

    protected abstract void initialize(Composition var1, AudioMode var2, File var3);

    protected abstract void finish();

    protected abstract boolean isVideoOutputting();

    protected abstract boolean isAudioOutputting();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void videoLoop(Composition comp, AudioMode audioMode, ProgressMonitor monitor) {
        AtiIntelLock atiIntelLock = AtiIntelLock.get(this._glGlobal);
        Time frameDuration = comp.getFrameDuration();
        long numFrames = comp.getDuration().toFrameNumber(frameDuration);
        monitor.beginTask((int)numFrames);
        this._context.activate();
        try {
            comp.prepareExpression(this._context.createInitialExpressionScope(comp));
            long i = 0L;
            while (i < numFrames && !monitor.isCanceled()) {
                Time time = Time.fromFrameNumber((long)i, (Time)frameDuration);
                this._context.reset();
                this._context.setVideoResolution(Resolution.FULL);
                this._context.setVideoFrameDuration(comp.getFrameDuration());
                this._context.setAudioMode(audioMode);
                this._context.setAudioAnimationRate(audioMode.sampleRate / 100);
                this._context.setTime(time);
                VideoBuffer vb = null;
                try {
                    atiIntelLock.lock();
                    try {
                        vb = comp.renderVideoFrame();
                        this._vrSupport.premultiply(vb);
                        this.writeVideo(i, time, vb);
                    }
                    finally {
                        atiIntelLock.unlock();
                    }
                }
                finally {
                    if (vb != null) {
                        vb.dispose();
                    }
                }
                monitor.currentWork((int)i);
                ++i;
            }
        }
        finally {
            this._context.deactivate();
        }
        monitor.done();
    }

    protected abstract void writeVideo(long var1, Time var3, VideoBuffer var4);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void audioLoop(Composition comp, AudioMode audioMode, ProgressMonitor monitor) {
        long totalFrames = comp.getDuration().toFrameNumber(audioMode.sampleDuration);
        int chunkFrames = audioMode.sampleRate;
        monitor.beginTask((int)totalFrames);
        this._context.activate();
        try {
            comp.prepareExpression(this._context.createInitialExpressionScope(comp));
            long i = 0L;
            while (i < totalFrames && !monitor.isCanceled()) {
                Time time = Time.fromFrameNumber((long)i, (Time)audioMode.sampleDuration);
                this._context.reset();
                this._context.setAudioMode(audioMode);
                this._context.setAudioAnimationRate(audioMode.sampleRate / 100);
                this._context.setAudioFrameCount((int)Math.min((long)chunkFrames, totalFrames - i));
                this._context.setVideoResolution(Resolution.FULL);
                this._context.setVideoFrameDuration(comp.getFrameDuration());
                this._context.setTime(time);
                AudioBuffer ab = comp.renderAudioChunk();
                try {
                    if (ab == null) {
                        ab = this.createAudioBufferClear();
                    }
                    this.writeAudio(i, time, ab);
                }
                finally {
                    ab.dispose();
                }
                monitor.currentWork((int)(i += (long)ab.getFrameCount()));
            }
        }
        finally {
            this._context.deactivate();
        }
        monitor.done();
    }

    protected abstract void writeAudio(long var1, Time var3, AudioBuffer var4);

    private AudioBuffer createAudioBufferClear() {
        AudioBuffer ab = this._arSupport.createAudioBuffer();
        switch (ab.getAudioMode().dataType) {
            case SHORT: {
                Arrays.fill((short[])ab.getData(), 0, ab.getDataLength(), (short)0);
                break;
            }
            case INT: {
                Arrays.fill((int[])ab.getData(), 0, ab.getDataLength(), 0);
                break;
            }
            case FLOAT: {
                Arrays.fill((float[])ab.getData(), 0, ab.getDataLength(), 0.0f);
                break;
            }
            default: {
                throw new UnsupportedOperationException("unsupported AudioMode.DataType: " + ab.getAudioMode().dataType);
            }
        }
        return ab;
    }
}

