/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl.x11.glx;

import com.sun.nativewindow.impl.NullWindow;
import com.sun.opengl.impl.GLContextShareSet;
import com.sun.opengl.impl.GLDrawableFactoryImpl;
import com.sun.opengl.impl.x11.glx.GLX;
import com.sun.opengl.impl.x11.glx.X11GLXContext;
import com.sun.opengl.impl.x11.glx.X11GLXDrawable;
import com.sun.opengl.impl.x11.glx.X11GLXGraphicsConfiguration;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.NativeWindow;
import javax.media.nativewindow.x11.X11GraphicsScreen;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;

public class X11ExternalGLXContext
extends X11GLXContext {
    private boolean firstMakeCurrent = true;
    private boolean created = true;
    private GLContext lastContext;

    private X11ExternalGLXContext(Drawable drawable, long l) {
        super(drawable, null);
        this.drawable = drawable;
        this.context = l;
        GLContextShareSet.contextCreated(this);
        this.setGLFunctionAvailability(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static X11ExternalGLXContext create(GLDrawableFactory gLDrawableFactory, GLProfile gLProfile) {
        ((GLDrawableFactoryImpl)gLDrawableFactory).lockToolkit();
        try {
            long l = GLX.glXGetCurrentContext();
            if (l == 0L) {
                throw new GLException("Error: current context null");
            }
            long l2 = GLX.glXGetCurrentDisplay();
            if (l2 == 0L) {
                throw new GLException("Error: current display null");
            }
            long l3 = GLX.glXGetCurrentDrawable();
            if (l3 == 0L) {
                throw new GLException("Error: attempted to make an external GLDrawable without a drawable/context current");
            }
            int[] nArray = new int[1];
            GLX.glXQueryContext(l2, l, 32780, nArray, 0);
            X11GraphicsScreen x11GraphicsScreen = (X11GraphicsScreen)X11GraphicsScreen.createScreenDevice((long)l2, (int)nArray[0]);
            GLX.glXQueryContext(l2, l, 32787, nArray, 0);
            X11GLXGraphicsConfiguration x11GLXGraphicsConfiguration = X11GLXGraphicsConfiguration.create(gLProfile, x11GraphicsScreen, nArray[0]);
            NullWindow nullWindow = new NullWindow((AbstractGraphicsConfiguration)x11GLXGraphicsConfiguration);
            nullWindow.setSurfaceHandle(l3);
            X11ExternalGLXContext x11ExternalGLXContext = new X11ExternalGLXContext(new Drawable(gLDrawableFactory, (NativeWindow)nullWindow), l);
            return x11ExternalGLXContext;
        }
        finally {
            ((GLDrawableFactoryImpl)gLDrawableFactory).unlockToolkit();
        }
    }

    protected void create() {
    }

    public int makeCurrent() throws GLException {
        GLContext gLContext = X11ExternalGLXContext.getCurrent();
        if (gLContext != null && gLContext != this) {
            this.lastContext = gLContext;
            X11ExternalGLXContext.setCurrent(null);
        }
        return super.makeCurrent();
    }

    public void release() throws GLException {
        super.release();
        X11ExternalGLXContext.setCurrent(this.lastContext);
        this.lastContext = null;
    }

    protected int makeCurrentImpl() throws GLException {
        if (this.firstMakeCurrent) {
            this.firstMakeCurrent = false;
            return 2;
        }
        return 1;
    }

    protected void releaseImpl() throws GLException {
    }

    protected void destroyImpl() throws GLException {
        this.created = false;
        GLContextShareSet.contextDestroyed(this);
    }

    public boolean isCreated() {
        return this.created;
    }

    static class Drawable
    extends X11GLXDrawable {
        Drawable(GLDrawableFactory gLDrawableFactory, NativeWindow nativeWindow) {
            super(gLDrawableFactory, nativeWindow, true);
        }

        public GLContext createContext(GLContext gLContext) {
            throw new GLException("Should not call this");
        }

        public int getWidth() {
            throw new GLException("Should not call this");
        }

        public int getHeight() {
            throw new GLException("Should not call this");
        }

        public void setSize(int n, int n2) {
            throw new GLException("Should not call this");
        }
    }
}

